/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.fitframework.plugin.http.server.tomcat.config.support;

import com.huawei.fitframework.plugin.http.server.tomcat.config.FileMonitor;
import com.huawei.fitframework.plugin.http.server.tomcat.exception.HttpsConfigMonitorException;
import java.io.File;
import java.io.IOException;
import java.nio.file.ClosedWatchServiceException;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WatchServiceFileMonitor
implements FileMonitor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WatchServiceFileMonitor.class);
    private static final long AWAIT_TIME = 10L;
    private final Path filePath;
    private final WatchService watchService;
    private final List<BiConsumer<File, String>> observerList;

    public WatchServiceFileMonitor(String file) {
        this.filePath = Paths.get(file, new String[0]);
        this.observerList = new ArrayList<BiConsumer<File, String>>();
        this.watchService = this.getWatchService();
    }

    @Override
    public void registerObserver(BiConsumer<File, String> observer) {
        this.observerList.add(observer);
    }

    @Override
    public void start() {
        String threadName = Thread.currentThread().getName();
        try {
            while (!Thread.interrupted()) {
                WatchKey watchKey = this.watchService.take();
                Thread.sleep(10L);
                watchKey.pollEvents().stream().distinct().filter(this::isMonitorFile).forEach(this::notifyObservers);
                if (watchKey.reset()) continue;
                log.error("Watch key reset failed. [thread={}]", (Object)threadName);
                break;
            }
        }
        catch (InterruptedException e) {
            log.error("Thread is interrupted. [thread={}]", (Object)threadName);
        }
        catch (ClosedWatchServiceException e) {
            log.warn("Watch service is closed.");
        }
    }

    private WatchService getWatchService() {
        try {
            WatchService newWatchService = FileSystems.getDefault().newWatchService();
            this.filePath.getParent().register(newWatchService, StandardWatchEventKinds.ENTRY_MODIFY, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_CREATE);
            return newWatchService;
        }
        catch (IOException e) {
            throw new HttpsConfigMonitorException(e.getMessage(), e);
        }
    }

    private boolean isMonitorFile(WatchEvent<?> event) {
        return event.context().toString().equals(this.filePath.getFileName().toString());
    }

    private void notifyObservers(WatchEvent<?> watchEvent) {
        this.observerList.forEach(observer -> observer.accept(this.filePath.toFile(), watchEvent.kind().name()));
    }

    @Override
    public void stop() {
        try {
            this.watchService.close();
        }
        catch (IOException e) {
            log.error("Close watch service failed. [errorMsg={}]", (Object)e.getMessage(), (Object)e);
            throw new HttpsConfigMonitorException(e.getMessage(), e);
        }
    }
}

