/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.fitframework.plugin.http.server.tomcat.servlet;

import com.huawei.fitframework.annotation.Fitable;
import com.huawei.fitframework.broker.Receiver;
import com.huawei.fitframework.broker.server.entity.RawResponse;
import com.huawei.fitframework.broker.server.http.FitServletSupplier;
import com.huawei.fitframework.broker.server.http.RequestMapping;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import javax.servlet.Servlet;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@Fitable
@RequestMapping(value="/fit")
public class FitServlet
extends HttpServlet
implements FitServletSupplier {
    private static final String FIT_METADATA = "FIT-METADATA";
    private static final String PARAM_DATA = "data";
    private final Receiver fitReceiver;

    public FitServlet(Receiver fitReceiver) {
        this.fitReceiver = fitReceiver;
    }

    public Servlet servlet() {
        return this;
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        Base64.Decoder decoder = Base64.getDecoder();
        String metadata = req.getHeader(FIT_METADATA);
        String data = req.getParameter(PARAM_DATA);
        RawResponse rawResponse = this.fitReceiver.receive(decoder.decode(metadata), decoder.decode(data));
        resp.setHeader(FIT_METADATA, FitServlet.encode(rawResponse.getMetadata()));
        resp.setStatus(200);
        byte[] bytes = FitServlet.encode(rawResponse.getData()).getBytes(StandardCharsets.UTF_8);
        try (ServletOutputStream outputStream = resp.getOutputStream();){
            outputStream.write(bytes);
            outputStream.flush();
        }
    }

    private static String encode(byte[] data) {
        return Base64.getEncoder().encodeToString(data);
    }
}

