/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.fitframework.registry.registry;

import com.huawei.fit.hakuna.kernel.registry.shared.entity.FitableMeta;
import com.huawei.fit.hakuna.kernel.shared.entity.Fitable;
import com.huawei.fitframework.annotation.Fit;
import com.huawei.fitframework.annotation.Order;
import com.huawei.fitframework.annotation.Value;
import com.huawei.fitframework.broker.BundleIdentity;
import com.huawei.fitframework.broker.conf.ConfigurationLoader;
import com.huawei.fitframework.broker.conf.GenericableConfiguration;
import com.huawei.fitframework.broker.serialization.SerializationService;
import com.huawei.fitframework.core.common.util.CollectionUtils;
import com.huawei.fitframework.core.common.util.ExceptionUtils;
import com.huawei.fitframework.core.common.util.ObjectUtils;
import com.huawei.fitframework.core.common.util.Validation;
import com.huawei.fitframework.registry.registry.service.RegisterFitableService;
import com.huawei.fitframework.runtime.ApplicationStartedObserver;
import com.huawei.fitframework.runtime.FitablesRegisteredListener;
import com.huawei.fitframework.runtime.FitablesRegisteredObserver;
import com.huawei.fitframework.runtime.PluginActivator;
import com.huawei.fitframework.runtime.PluginBrief;
import com.huawei.fitframework.runtime.PluginStartedObserver;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.annotation.PostConstruct;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@com.huawei.fitframework.annotation.Fitable
@Order(value=-500)
public class RegistryClient
implements PluginStartedObserver,
ApplicationStartedObserver,
FitablesRegisteredListener,
PluginActivator {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RegistryClient.class);
    private static final int OFFLINE_BATCH_SIZE = 20;
    private static final long DEFAULT_DELAYED = 5L;
    private static final TimeUnit DEFAULT_DELAYED_UNIT = TimeUnit.SECONDS;
    private static final int POOL_SIZE = 10;
    private static final long ONE_MINUTE = 60L;
    private final Set<FitableMeta> registeringFitables = ConcurrentHashMap.newKeySet();
    private volatile boolean fitablesAlreadyRegistered = false;
    private final RegisterFitableService registerFitableService;
    private final SerializationService serializationService;
    private final ScheduledThreadPoolExecutor executor;
    private final Set<FitablesRegisteredObserver> fitablesRegisteredObservers = new HashSet<FitablesRegisteredObserver>();
    private final long syncRegistryPeriod;
    private final ConfigurationLoader configurationLoader;
    private final long terminateTimeout;

    public RegistryClient(@Fit RegisterFitableService registerFitableService, @Fit SerializationService serializationService, @Fit ConfigurationLoader configurationLoader, @Value(value="${registry.sync.period}") long syncRegistryPeriod, @Value(value="${registry.terminate.timeout}") long terminateTimeout) {
        this.registerFitableService = registerFitableService;
        this.serializationService = serializationService;
        this.configurationLoader = configurationLoader;
        this.syncRegistryPeriod = Validation.greaterThan((long)syncRegistryPeriod, (long)0L, (String)"SyncRegistryPeriod should greater than 0 seconds. [syncRegistryPeriod={0}]", (Object[])new Object[]{syncRegistryPeriod});
        log.info("SyncRegistryPeriod is {} second.", (Object)this.syncRegistryPeriod);
        this.terminateTimeout = Validation.greaterThan((long)terminateTimeout, (long)0L, (String)"terminateTimeout should greater than 0 seconds. [terminateTimeout={0}]", (Object[])new Object[]{terminateTimeout});
        log.info("terminateTimeout is {} second.", (Object)this.terminateTimeout);
        this.executor = (ScheduledThreadPoolExecutor)ObjectUtils.cast((Object)Executors.newScheduledThreadPool(10));
        this.executor.setKeepAliveTime(60L, TimeUnit.SECONDS);
        this.executor.allowCoreThreadTimeOut(true);
    }

    @PostConstruct
    public void init() {
        log.info("Start scheduled task to register fitables. [period={} seconds]", (Object)this.syncRegistryPeriod);
    }

    public void onPluginStarted(PluginBrief plugin) {
        this.addFitableMetas(plugin);
        log.info("Fitable metas ready to register, [size={}, pluginName={}]", (Object)plugin.getLocalFitableIdentities().size(), (Object)plugin.getName());
        if (this.fitablesAlreadyRegistered) {
            this.registerFitableService.onlineFitables(this.registeringFitables);
        }
    }

    private void addFitableMetas(PluginBrief plugin) {
        plugin.getLocalFitableIdentities().stream().filter(Objects::nonNull).map(this::toFitableMeta).filter(fitableMeta -> !this.isGenericableLocalOnly(fitableMeta.getFitable().getGenericableId())).forEach(this.registeringFitables::add);
    }

    private boolean isGenericableLocalOnly(String genericableId) {
        return this.configurationLoader.load().genericable(genericableId).map(GenericableConfiguration::tags).map(tags -> tags.stream().anyMatch(tag -> Objects.equals(tag, "localOnly"))).orElse(false);
    }

    private FitableMeta toFitableMeta(BundleIdentity bundle) {
        Fitable fitable = Fitable.builder().genericableId(bundle.getGenericId()).genericableVersion("1.0.0").fitableId(bundle.getFitId()).build();
        Set supportedFormats = this.serializationService.getSupportedFormats(bundle.getGenericId());
        return FitableMeta.builder().fitable(fitable).formats(new ArrayList(supportedFormats)).build();
    }

    public void onApplicationStarted(List<PluginBrief> plugins) {
        if (CollectionUtils.isEmpty(this.registeringFitables)) {
            log.info("No fitables need to register, skip.");
            return;
        }
        this.onlineFitables();
    }

    public void addObserver(FitablesRegisteredObserver observer) {
        Validation.notNull((Object)observer, (String)"No observer.", (Object[])new Object[0]);
        this.fitablesRegisteredObservers.add(observer);
    }

    protected void onlineFitables() {
        this.executor.submit(new OnlineFitable(this.registerFitableService, this.registeringFitables));
    }

    public void start() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        ExecutorService executor = Executors.newSingleThreadExecutor();
        Future<?> future = executor.submit(this::stopTask);
        try {
            future.get(this.terminateTimeout, TimeUnit.SECONDS);
        }
        catch (InterruptedException | ExecutionException e) {
            log.warn("Fail to execute stop task from registry client: {}.", (Object)ExceptionUtils.getReason((Throwable)e));
        }
        catch (TimeoutException e) {
            log.warn("Fail to execute stop task from registry client: task was timeout.");
            future.cancel(true);
        }
        finally {
            executor.shutdownNow();
        }
    }

    private void stopTask() {
        boolean awaitTermination;
        this.executor.shutdownNow();
        try {
            awaitTermination = this.executor.awaitTermination(Long.MAX_VALUE, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            log.warn("Fail to execute stop task from registry client: await termination was interrupted.", (Throwable)e);
            return;
        }
        if (!awaitTermination) {
            log.warn("Fail to execute stop task from registry client: await termination was timeout.");
        }
        log.info("Start to offline fit service.");
        CollectionUtils.split(new HashSet<FitableMeta>(this.registeringFitables), (int)20).forEach(subServices -> this.registerFitableService.offlineFitables(new HashSet<FitableMeta>((Collection<FitableMeta>)subServices)));
        log.info("Success to offline fit service.");
    }

    @Generated
    public Set<FitableMeta> getRegisteringFitables() {
        return this.registeringFitables;
    }

    private class OnlineFitable
    implements Runnable {
        private final RegisterFitableService registerFitableService;
        private final Set<FitableMeta> registeringFitables;

        OnlineFitable(RegisterFitableService registerFitableService, Set<FitableMeta> registeringFitables) {
            this.registerFitableService = registerFitableService;
            this.registeringFitables = registeringFitables;
        }

        @Override
        public void run() {
            try {
                this.registerFitableService.onlineFitables(this.registeringFitables);
                if (!RegistryClient.this.fitablesAlreadyRegistered) {
                    RegistryClient.this.fitablesAlreadyRegistered = true;
                    RegistryClient.this.fitablesRegisteredObservers.forEach(FitablesRegisteredObserver::onFitablesRegistered);
                }
                RegistryClient.this.executor.schedule(new OnlineFitable(this.registerFitableService, this.registeringFitables), RegistryClient.this.syncRegistryPeriod, TimeUnit.SECONDS);
            }
            catch (Exception e) {
                log.info("Fail to online fitables. Retrying...");
                log.debug("Fail to online fit fitables. [fitableSize={}]", (Object)this.registeringFitables.size(), (Object)e);
                this.registeringFitables.forEach(fitableMeta -> log.debug("Fail to online. [fitable={}]", fitableMeta));
                RegistryClient.this.executor.schedule(new OnlineFitable(this.registerFitableService, this.registeringFitables), 5L, DEFAULT_DELAYED_UNIT);
            }
        }
    }
}

