/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.fitframework.registry.registry.service.support;

import com.huawei.fit.hakuna.kernel.registry.server.RegisterFitables;
import com.huawei.fit.hakuna.kernel.registry.server.UnregisterFitables;
import com.huawei.fit.hakuna.kernel.registry.shared.entity.Address;
import com.huawei.fit.hakuna.kernel.registry.shared.entity.Application;
import com.huawei.fit.hakuna.kernel.registry.shared.entity.Endpoint;
import com.huawei.fit.hakuna.kernel.registry.shared.entity.FitableMeta;
import com.huawei.fit.hakuna.kernel.registry.shared.entity.Worker;
import com.huawei.fit.hakuna.kernel.shared.entity.Fitable;
import com.huawei.fit.heartbeat.OnlineHeartbeat;
import com.huawei.fit.heartbeat.entity.BeatInfo;
import com.huawei.fit.sdk.system.GetLocalAddresses;
import com.huawei.fitframework.annotation.Fit;
import com.huawei.fitframework.annotation.Value;
import com.huawei.fitframework.broker.serialization.SerializationService;
import com.huawei.fitframework.core.common.util.CollectionUtils;
import com.huawei.fitframework.core.common.util.ExceptionUtils;
import com.huawei.fitframework.core.common.util.ObjectUtils;
import com.huawei.fitframework.core.common.util.Validation;
import com.huawei.fitframework.registry.registry.service.RegisterFitableService;
import com.huawei.fitframework.registry.registry.utils.AppNameVersionUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@com.huawei.fitframework.annotation.Fitable
public class DefaultRegisterFitableService
implements RegisterFitableService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultRegisterFitableService.class);
    private static final String HEARTBEAT_TYPE_REGISTRY = "fit_registry";
    private final OnlineHeartbeat onlineHeartbeat;
    private final GetLocalAddresses getLocalAddresses;
    private final SerializationService serializationService;
    private final RegisterFitables registerFitables;
    private final UnregisterFitables unregisterFitables;
    private final String appName;
    private final long syncHeartbeatInitDelay;
    private final long syncHeartbeatPeriod;
    private final long syncHeartbeatAliveTime;
    private final int workerExpire;
    private final String localWorkerId;

    public DefaultRegisterFitableService(@Fit OnlineHeartbeat onlineHeartbeat, @Fit GetLocalAddresses getLocalAddresses, @Fit SerializationService serializationService, @Fit(retry=1) RegisterFitables registerFitables, @Fit(retry=1) UnregisterFitables unregisterFitables, @Value(value="${app.name}") String appName, @Value(value="${heartbeat.sync.init-delay}") long syncHeartbeatInitDelay, @Value(value="${heartbeat.sync.period}") long syncHeartbeatPeriod, @Value(value="${heartbeat.sync.alive-time}") long syncHeartbeatAliveTime, @Value(value="${worker.expire}") int workerExpire, @Value(value="${server.id}") String workerId) {
        this.onlineHeartbeat = onlineHeartbeat;
        this.getLocalAddresses = getLocalAddresses;
        this.serializationService = serializationService;
        this.registerFitables = registerFitables;
        this.unregisterFitables = unregisterFitables;
        this.appName = appName;
        this.syncHeartbeatInitDelay = Validation.greaterThan((long)syncHeartbeatInitDelay, (long)0L, (String)"SyncHeartbeatInitDelay should greater than 0 seconds. [syncHeartbeatInitDelay={0}]", (Object[])new Object[]{syncHeartbeatInitDelay});
        log.info("SyncHeartbeatInitDelay is {} second.", (Object)this.syncHeartbeatInitDelay);
        this.syncHeartbeatPeriod = Validation.greaterThan((long)syncHeartbeatPeriod, (long)0L, (String)"SyncHeartbeatPeriod should greater than 0 seconds. [syncHeartbeatPeriod={0}]", (Object[])new Object[]{syncHeartbeatPeriod});
        log.info("SyncHeartbeatPeriod is {} second.", (Object)this.syncHeartbeatPeriod);
        this.syncHeartbeatAliveTime = Validation.greaterThan((long)syncHeartbeatAliveTime, (long)0L, (String)"SyncHeartbeatAliveTime should greater than 0 seconds. [syncHeartbeatAliveTime={0}]", (Object[])new Object[]{syncHeartbeatPeriod});
        log.info("SyncHeartbeatAliveTime is {} second.", (Object)this.syncHeartbeatAliveTime);
        this.workerExpire = workerExpire;
        log.info("Worker expire time is {} second.", (Object)this.workerExpire);
        this.localWorkerId = workerId;
        log.info("The local worker id is {}.", (Object)this.localWorkerId);
    }

    @Override
    public void onlineFitables(Set<FitableMeta> fitableMetas) {
        if (CollectionUtils.isEmpty(fitableMetas)) {
            log.warn("No fitables need to be registered, skip.");
            return;
        }
        Validation.isTrue((boolean)this.onlineHeartbeat(), (String)"Fail to online heartbeat.", (Object[])new Object[0]);
        Worker worker = this.buildWorker();
        this.registerAllFitables(new ArrayList<FitableMeta>(fitableMetas), worker);
        log.info("Online fitables successfully. [local addresses={}]", (Object)worker.getAddresses());
    }

    @Override
    public void offlineFitables(Set<FitableMeta> fitableMetas) {
        Set<Fitable> fitables = this.toFitables(fitableMetas);
        try {
            log.debug("Prepare to unregister fitables. [fitables={}, workerId={}]", fitables, (Object)this.localWorkerId);
            this.unregisterFitables.process(new ArrayList<Fitable>(fitables), this.localWorkerId);
            log.debug("Unregister fitables successfully. [fitables={}, workerId={}]", fitableMetas, (Object)this.localWorkerId);
        }
        catch (Exception e) {
            log.warn("Fail to unregister fitables. [fitables={}, workerId={}]", fitables, (Object)this.localWorkerId);
        }
    }

    private Set<Fitable> toFitables(Set<FitableMeta> fitableMetas) {
        return fitableMetas.stream().filter(Objects::nonNull).filter(fitableMeta -> fitableMeta.getFitable() != null).map(this::toFitable).collect(Collectors.toSet());
    }

    private Fitable toFitable(FitableMeta fitableMeta) {
        return Fitable.builder().genericableId(fitableMeta.getFitable().getGenericableId()).genericableVersion(fitableMeta.getFitable().getGenericableVersion()).fitableId(fitableMeta.getFitable().getFitableId()).fitableVersion(fitableMeta.getFitable().getFitableVersion()).build();
    }

    private boolean onlineHeartbeat() {
        BeatInfo beatInfo = BeatInfo.builder().sceneType(HEARTBEAT_TYPE_REGISTRY).initDelay(Long.valueOf(this.syncHeartbeatInitDelay * 1000L)).interval(Long.valueOf(this.syncHeartbeatPeriod * 1000L)).aliveTime(Long.valueOf(this.syncHeartbeatAliveTime * 1000L)).build();
        return this.onlineHeartbeat(beatInfo);
    }

    private boolean onlineHeartbeat(BeatInfo beatInfo) {
        try {
            boolean isSuccess = (Boolean)ObjectUtils.nullIf((Object)this.onlineHeartbeat.process(beatInfo), (Object)false);
            if (isSuccess) {
                log.info("Online heartbeat successfully. [beatInfo={}]", (Object)beatInfo);
            } else {
                log.warn("Fail to online heartbeat. [beatInfo={}]", (Object)beatInfo);
            }
            return isSuccess;
        }
        catch (Exception e) {
            log.error("Fail to online heartbeat: {}. [beatInfo={}]", (Object)ExceptionUtils.getReason((Throwable)e), (Object)beatInfo);
            log.debug("Fail to online heartbeat.", (Throwable)e);
            return false;
        }
    }

    private FitableMeta buildFitableMetaWithFormats(FitableMeta fitableMeta) {
        Set supportedFormats = this.serializationService.getSupportedFormats(fitableMeta.getFitable().getGenericableId());
        fitableMeta.setFormats(new ArrayList(supportedFormats));
        return fitableMeta;
    }

    private Worker buildWorker() {
        List<com.huawei.fit.registry.entity.Address> localAddresses = this.getLocalAddresses();
        return Worker.builder().id(this.localWorkerId).addresses(this.buildAddresses(localAddresses)).environment(localAddresses.iterator().next().getEnvironment()).expire(Integer.valueOf(this.workerExpire)).build();
    }

    private Application buildApplication(List<FitableMeta> fitableMetas) {
        List<FitableMeta> fitableMetasWithFormats = fitableMetas.stream().map(this::buildFitableMetaWithFormats).collect(Collectors.toList());
        return Application.builder().name(this.appName).nameVersion(AppNameVersionUtil.calculateAppNameVersion(fitableMetasWithFormats)).build();
    }

    private List<Address> buildAddresses(List<com.huawei.fit.registry.entity.Address> localAddresses) {
        Map<String, List<com.huawei.fit.registry.entity.Address>> hostLocalAddressesMap = localAddresses.stream().collect(Collectors.groupingBy(com.huawei.fit.registry.entity.Address::getHost));
        return hostLocalAddressesMap.keySet().stream().map(host -> this.buildAddress((List)hostLocalAddressesMap.get(host))).collect(Collectors.toList());
    }

    private Address buildAddress(List<com.huawei.fit.registry.entity.Address> addresses) {
        List endpoints = addresses.stream().map(address -> Endpoint.builder().port(address.getPort()).protocol(address.getProtocol()).build()).collect(Collectors.toList());
        return Address.builder().host(addresses.iterator().next().getHost()).endpoints(endpoints).build();
    }

    private List<com.huawei.fit.registry.entity.Address> getLocalAddresses() {
        try {
            log.debug("Prepare to get local addresses.");
            return this.getLocalAddresses.process().stream().filter(Objects::nonNull).collect(Collectors.toList());
        }
        catch (Exception e) {
            log.error("Fail to get local addresses: {}.", (Object)ExceptionUtils.getReason((Throwable)e));
            log.debug("Fail to get local addresses.", (Throwable)e);
            return Collections.emptyList();
        }
    }

    private void registerAllFitables(List<FitableMeta> fitableMetas, Worker worker) {
        try {
            log.debug("Prepare to register fitables. [fitables={}, worker={}]", fitableMetas, (Object)worker);
            this.registerFitables.process(fitableMetas, worker, this.buildApplication(fitableMetas));
            log.debug("Register fitables successfully. [fitables={}, worker={}", fitableMetas, (Object)worker);
        }
        catch (Exception e) {
            log.error("Fail to register fitables. [fitables={}, worker={}]", fitableMetas, (Object)worker);
            log.debug("Fail to register fitables.", (Throwable)e);
        }
    }
}

