/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.fitframework.registry.registry.utils;

import com.huawei.fit.hakuna.kernel.registry.shared.entity.FitableMeta;
import com.huawei.fit.hakuna.kernel.shared.entity.Fitable;
import com.huawei.fitframework.core.common.util.StringUtils;
import com.huawei.fitframework.registry.registry.utils.DigestUtil;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AppNameVersionUtil {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AppNameVersionUtil.class);
    private static final String ALGORITHM_TYPE = "MD5";
    private static final String DELIMITER_BETWEEN_FORMATS = ",";
    private static final String FITABLE_STRING_FORMAT = "{0}:{1}:{2}:{3}:{4};";

    public static String calculateAppNameVersion(List<FitableMeta> fitableMetasWithFormats) {
        List<String> fitableStrings = fitableMetasWithFormats.stream().filter(Objects::nonNull).filter(fitableMeta -> fitableMeta.getFitable() != null).map(AppNameVersionUtil::buildFitableString).sorted().collect(Collectors.toList());
        return DigestUtil.getValue(fitableStrings, ALGORITHM_TYPE);
    }

    private static String buildFitableString(FitableMeta fitableMeta) {
        Fitable fitable = fitableMeta.getFitable();
        return StringUtils.format((String)FITABLE_STRING_FORMAT, (Object[])new Object[]{fitable.getGenericableId(), Optional.ofNullable(fitable.getGenericableVersion()).orElse(""), fitable.getFitableId(), Optional.ofNullable(fitable.getFitableVersion()).orElse(""), AppNameVersionUtil.buildFormatsString(fitableMeta)});
    }

    private static String buildFormatsString(FitableMeta fitableMeta) {
        return fitableMeta.getFormats().stream().map(String::valueOf).sorted().collect(Collectors.joining(DELIMITER_BETWEEN_FORMATS));
    }
}

