/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.fitframework.http.entity.support;

import com.huawei.fitframework.core.common.util.StringUtils;
import com.huawei.fitframework.http.entity.Cookie;
import com.huawei.fitframework.http.entity.HttpRequest;
import com.huawei.fitframework.http.entity.support.DefaultHttpRequestBuilder;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TimeZone;
import java.util.stream.Collectors;

public class DefaultHttpRequest
implements HttpRequest {
    private static final List<String> DATE_FORMATS = Arrays.asList("EEE, dd MMM yyyy HH:mm:ss zzz", "EEE, dd-MMM-yy HH:mm:ss zzz", "EEE MMM dd HH:mm:ss yyyy");
    private static final TimeZone GMT = TimeZone.getTimeZone("GMT");
    private static final String HOST_HEADER_NAME = "host";
    private static final String HOST_SEPARATOR = ":";
    private static final String CONTENT_LENGTH_HEADER_NAME = "content-length";
    private static final int DEFAULT_SERVER_PORT = 80;
    private final String method;
    private final String requestURI;
    private final String queryString;
    private final String protocol;
    private final String remoteAddress;
    private final int remotePort;
    private final String remoteHost;
    private final String localAddress;
    private final String localHostName;
    private final int localPort;
    private final String scheme;
    private final StringBuilder requestURL;
    private final List<Cookie> cookies;
    private final Map<String, String> headers;
    private final Map<String, List<String>> parameters;
    private final String characterEncoding;
    private final String languageTag;
    private final Set<String> languageTags;
    private final boolean secure;

    DefaultHttpRequest(String method, String requestURI, String queryString, String protocol, String remoteAddr, int remotePort, String remoteHost, String localAddr, String localName, int localPort, String scheme, StringBuilder requestURL, List<Cookie> cookies, Map<String, String> headers, Map<String, List<String>> parameters, String characterEncoding, String languageTag, Set<String> languageTags, boolean secure) {
        this.method = method;
        this.requestURI = requestURI;
        this.queryString = queryString;
        this.protocol = protocol;
        this.remoteAddress = remoteAddr;
        this.remotePort = remotePort;
        this.remoteHost = remoteHost;
        this.localAddress = localAddr;
        this.localHostName = localName;
        this.localPort = localPort;
        this.scheme = scheme;
        this.requestURL = requestURL;
        this.cookies = Optional.ofNullable(cookies).orElseGet(ArrayList::new);
        this.headers = Optional.ofNullable(headers).orElseGet(HashMap::new);
        this.parameters = Optional.ofNullable(parameters).orElseGet(HashMap::new);
        this.characterEncoding = characterEncoding;
        this.languageTag = languageTag;
        this.languageTags = Optional.ofNullable(languageTags).orElseGet(HashSet::new);
        this.secure = secure;
    }

    @Override
    public String getMethod() {
        return this.method;
    }

    @Override
    public String getRequestURI() {
        return this.requestURI;
    }

    @Override
    public String getQueryString() {
        return this.queryString;
    }

    @Override
    public String getProtocol() {
        return this.protocol;
    }

    @Override
    public String getRemoteAddress() {
        return this.remoteAddress;
    }

    @Override
    public int getRemotePort() {
        return this.remotePort;
    }

    @Override
    public String getRemoteHost() {
        return this.remoteHost;
    }

    @Override
    public String getLocalAddress() {
        return this.localAddress;
    }

    @Override
    public String getLocalHostName() {
        return this.localHostName;
    }

    @Override
    public int getLocalPort() {
        return this.localPort;
    }

    @Override
    public String getServerHostName() {
        String host = this.getHeader(HOST_HEADER_NAME);
        if (host == null || !host.contains(HOST_SEPARATOR)) {
            return host;
        }
        return host.substring(0, host.indexOf(HOST_SEPARATOR));
    }

    @Override
    public int getServerPort() {
        String host = this.getHeader(HOST_HEADER_NAME);
        if (host == null || !host.contains(HOST_SEPARATOR)) {
            return 80;
        }
        return Integer.parseInt(host.substring(host.indexOf(HOST_SEPARATOR) + 1));
    }

    @Override
    public String getScheme() {
        return this.scheme;
    }

    @Override
    public StringBuilder getRequestURL() {
        return this.requestURL;
    }

    @Override
    public List<Cookie> getCookies() {
        return this.cookies;
    }

    @Override
    public String getHeader(String name) {
        return this.headers.get(StringUtils.toLowerCase((String)name));
    }

    @Override
    public Set<String> getHeaderNames() {
        return this.headers.keySet();
    }

    @Override
    public int getIntHeader(String name) {
        String value = this.getHeader(name);
        return value == null ? -1 : Integer.parseInt(value);
    }

    @Override
    public long getDateHeader(String name) {
        String value = this.getHeader(name);
        if (value == null) {
            return -1L;
        }
        return DATE_FORMATS.stream().map(dateFormat -> this.dateParse(value, (String)dateFormat)).filter(formattedValue -> formattedValue != -1L).findFirst().orElseThrow(() -> new IllegalArgumentException("parse date error for '" + name + "' header"));
    }

    private long dateParse(String value, String dateFormat) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(dateFormat, Locale.US);
        simpleDateFormat.setTimeZone(GMT);
        try {
            return simpleDateFormat.parse(value).getTime();
        }
        catch (ParseException e) {
            return -1L;
        }
    }

    @Override
    public String getParameter(String name) {
        List<String> parameterValues = this.getParameterValues(name);
        return parameterValues.isEmpty() ? null : parameterValues.get(0);
    }

    @Override
    public List<String> getParameterValues(String name) {
        Map<String, List<String>> parameterMap = this.getParameterMap();
        if (parameterMap == null || !parameterMap.containsKey(name)) {
            return Collections.emptyList();
        }
        return parameterMap.get(name);
    }

    @Override
    public Set<String> getParameterNames() {
        return this.parameters.keySet();
    }

    @Override
    public Map<String, List<String>> getParameterMap() {
        return this.parameters;
    }

    @Override
    public String getCharacterEncoding() {
        return this.characterEncoding;
    }

    @Override
    public int getContentLength() {
        long length = this.getContentLengthLong();
        if (length == -1L || length > Integer.MAX_VALUE) {
            return -1;
        }
        return (int)length;
    }

    @Override
    public long getContentLengthLong() {
        String length = this.getHeader(CONTENT_LENGTH_HEADER_NAME);
        if (StringUtils.isBlank((String)length)) {
            return -1L;
        }
        return Long.parseLong(length);
    }

    @Override
    public Locale getLocale() {
        if (StringUtils.isBlank((String)this.languageTag)) {
            return null;
        }
        return Locale.forLanguageTag(this.languageTag);
    }

    @Override
    public Set<Locale> getLocales() {
        return this.languageTags.stream().map(Locale::forLanguageTag).collect(Collectors.toSet());
    }

    @Override
    public boolean isSecure() {
        return this.secure;
    }

    public static DefaultHttpRequestBuilder builder() {
        return new DefaultHttpRequestBuilder();
    }
}

