/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.fitframework.broker.client.ioc;

import com.huawei.fitframework.annotation.Alias;
import com.huawei.fitframework.annotation.Fitable;
import com.huawei.fitframework.annotation.FitableSuite;
import com.huawei.fitframework.core.common.util.StringUtils;
import com.huawei.fitframework.ioc.ComponentBrief;
import com.huawei.fitframework.ioc.ComponentResolver;
import com.huawei.fitframework.ioc.util.StereotypeUtils;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Collectors;

public class FitableComponentResolver
implements ComponentResolver {
    private static final Resolver CHAIN = Resolver.combine(FitableComponentResolver::resolveFitableSuite, FitableComponentResolver::resolvePrivateFitable);

    public void resolve(Class<?> objectClass, Consumer<ComponentBrief> componentDetectedCallback) {
        CHAIN.resolve(objectClass, componentDetectedCallback);
    }

    private static boolean resolvePrivateFitable(Class<?> objectClass, Consumer<ComponentBrief> callback) {
        Fitable annotation = objectClass.getDeclaredAnnotation(Fitable.class);
        if (annotation == null) {
            return false;
        }
        callback.accept(ComponentBrief.builder().setComponentName(FitableComponentResolver.getFitableComponentName(objectClass)).setComponentClass(objectClass).setStereotype(StereotypeUtils.getStereotype(objectClass)).build());
        return true;
    }

    private static boolean resolveFitableSuite(Class<?> objectClass, Consumer<ComponentBrief> callback) {
        FitableSuite annotation = objectClass.getDeclaredAnnotation(FitableSuite.class);
        if (annotation == null) {
            return false;
        }
        String scope = StereotypeUtils.getStereotype(objectClass);
        if (StringUtils.equalsIgnoreCase((String)scope, (String)"prototype")) {
            throw new IllegalStateException(StringUtils.format((String)"Fitable set cannot be prototype. [class={0}]", (Object[])new Object[]{objectClass.getName()}));
        }
        callback.accept(ComponentBrief.builder().setComponentName(objectClass.getName()).setComponentClass(objectClass).setStereotype("singleton").build());
        return true;
    }

    private static String getFitableComponentName(Class<?> objectClass) {
        Alias alias = objectClass.getAnnotation(Alias.class);
        if (alias != null) {
            return alias.value();
        }
        return objectClass.getName();
    }

    @FunctionalInterface
    private static interface Resolver {
        public boolean resolve(Class<?> var1, Consumer<ComponentBrief> var2);

        public static Resolver combine(Resolver ... resolvers) {
            if (resolvers == null) {
                return (objectClass, callback) -> false;
            }
            List actualResolvers = Arrays.stream(resolvers).filter(Objects::nonNull).collect(Collectors.toList());
            return (objectClass, callback) -> {
                for (Resolver resolver : actualResolvers) {
                    if (!resolver.resolve(objectClass, callback)) continue;
                    return true;
                }
                return false;
            };
        }
    }
}

