/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.fitframework.broker.client.ioc;

import com.huawei.fitframework.annotation.Fit;
import com.huawei.fitframework.broker.client.BrokerClient;
import com.huawei.fitframework.broker.client.InvokeContext;
import com.huawei.fitframework.broker.client.support.DefaultInvokeContext;
import com.huawei.fitframework.broker.client.util.AnnotationUtils;
import com.huawei.fitframework.core.common.util.CollectionUtils;
import com.huawei.fitframework.core.common.util.MapBuilder;
import com.huawei.fitframework.core.common.util.StringUtils;
import com.huawei.fitframework.ioc.ComponentBrief;
import com.huawei.fitframework.ioc.DependencyResolver;
import com.huawei.fitframework.ioc.DependencyResolvingResult;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import lombok.Generated;

public class FitableDependencyResolver
implements DependencyResolver {
    private final Map<Policy, FitAnnotationResolver> dependencyResolvers = MapBuilder.get().put((Object)Policy.ALIAS, this::resolveByAlias).put((Object)Policy.RULE, this::resolveByRule).put((Object)Policy.DEFAULT, this::resolveByDefault).build();
    private final BrokerClient brokerClient;

    public FitableDependencyResolver(BrokerClient brokerClient) {
        this.brokerClient = brokerClient;
    }

    public boolean isPreferredConstructor(Constructor<?> constructor) {
        return AnnotationUtils.isFitAnnotationDeclared(constructor);
    }

    public boolean isResolvable(ComponentBrief brief, Parameter parameter) {
        Executable method = parameter.getDeclaringExecutable();
        if (method instanceof Constructor) {
            Constructor<?>[] constructors = method.getDeclaringClass().getDeclaredConstructors();
            if (constructors.length == 1) {
                return true;
            }
            return AnnotationUtils.isFitAnnotationDeclared((AnnotatedElement)parameter) || AnnotationUtils.isFitAnnotationDeclared((AnnotatedElement)method);
        }
        return false;
    }

    public boolean isResolvable(ComponentBrief brief, Field field) {
        return AnnotationUtils.isFitAnnotationDeclared((AnnotatedElement)field);
    }

    public DependencyResolvingResult resolve(ComponentBrief brief, Parameter parameter) {
        return this.resolve(parameter, parameter.getType(), parameter.getParameterizedType());
    }

    public DependencyResolvingResult resolve(ComponentBrief brief, Object bean, Field field) {
        return this.resolve(field, field.getType(), field.getGenericType());
    }

    private DependencyResolvingResult resolve(AnnotatedElement element, Class<?> requiredClass, Type requiredType) {
        Policy policy = Policy.fromCode(AnnotationUtils.getQualifiedPolicy((AnnotatedElement)element));
        Fit fitAnnotation = AnnotationUtils.getFitAnnotation((AnnotatedElement)element).orElse(null);
        InvokeContext invokeContext = DefaultInvokeContext.fromFitAnnotation((Fit)fitAnnotation);
        return this.dependencyResolvers.getOrDefault((Object)policy, this::resolveByDefault).resolve(element, requiredClass, requiredType, invokeContext);
    }

    private DependencyResolvingResult resolveByAlias(AnnotatedElement element, Class<?> requiredClass, Type requiredType, InvokeContext invokeContext) {
        String alias = (String)AnnotationUtils.getQualifiedAlias((AnnotatedElement)element).orElseThrow(() -> new IllegalStateException("No alias."));
        return FitableDependencyResolver.result(this.brokerClient.getProxyByAlias(requiredClass, alias, invokeContext));
    }

    private DependencyResolvingResult resolveByRule(AnnotatedElement element, Class<?> requiredClass, Type requiredType, InvokeContext invokeContext) {
        return FitableDependencyResolver.result(this.brokerClient.getProxyByRule(requiredClass, invokeContext));
    }

    private DependencyResolvingResult resolveByDefault(AnnotatedElement element, Class<?> requiredClass, Type requiredType, InvokeContext invokeContext) {
        if (requiredType instanceof Class) {
            return FitableDependencyResolver.result(this.brokerClient.getProxyByDefault((Class)requiredType, invokeContext));
        }
        Map proxies = this.brokerClient.list(requiredType);
        if (proxies.size() > 1) {
            throw new IllegalStateException(StringUtils.format((String)"Multiply proxies found and cannot determine which to use. [requiredType={0}, proxies={1}]", (Object[])new Object[]{requiredType.getTypeName(), CollectionUtils.toString(proxies.keySet())}));
        }
        if (proxies.size() > 0) {
            return DependencyResolvingResult.create(proxies.values().iterator().next());
        }
        if (requiredType instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)requiredType;
            Class rawClass = (Class)parameterizedType.getRawType();
            Type[] arguments = parameterizedType.getActualTypeArguments();
            if (Objects.equals(rawClass, List.class)) {
                return DependencyResolvingResult.create(Collections.unmodifiableList(new ArrayList(this.brokerClient.list(arguments[0]).values())));
            }
            if (Objects.equals(rawClass, Map.class) && Objects.equals(arguments[0], String.class)) {
                return DependencyResolvingResult.create(Collections.unmodifiableMap(this.brokerClient.list(parameterizedType.getActualTypeArguments()[1])));
            }
        }
        return DependencyResolvingResult.failure();
    }

    private static DependencyResolvingResult result(Object proxy) {
        return proxy == null ? DependencyResolvingResult.failure() : DependencyResolvingResult.create((Object)proxy);
    }

    static enum Policy {
        DEFAULT("default"),
        ALIAS("alias"),
        RULE("rule");

        private final String code;

        private Policy(String code) {
            this.code = code;
        }

        static Policy fromCode(String code) {
            for (Policy policy : Policy.values()) {
                if (!Objects.equals(code, policy.name())) continue;
                return policy;
            }
            return null;
        }

        @Generated
        public String getCode() {
            return this.code;
        }
    }

    @FunctionalInterface
    private static interface FitAnnotationResolver {
        public DependencyResolvingResult resolve(AnnotatedElement var1, Class<?> var2, Type var3, InvokeContext var4);
    }
}

