/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.fitframework.broker.client.proxy.support;

import com.huawei.fitframework.broker.client.InvokeContext;
import com.huawei.fitframework.broker.client.proxy.Proxy;
import com.huawei.fitframework.broker.client.proxy.ProxyFactory;
import com.huawei.fitframework.broker.client.util.AnnotationUtils;
import com.huawei.fitframework.core.common.util.ObjectUtils;
import com.huawei.fitframework.core.common.util.ReflectionUtils;
import com.huawei.fitframework.core.common.util.Validation;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractProxy
implements Proxy {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractProxy.class);
    private final ProxyFactory factory;
    private Class<?> genericableClass;
    private final String genericableId;
    private final String fitableId;
    private List<Parameter> parameters;
    private Type returnType;
    private final InvokeContext invokeContext;

    protected AbstractProxy(ProxyFactory factory, String genericableId, String fitableId, InvokeContext invokeContext) {
        this.factory = factory;
        this.genericableId = genericableId;
        this.fitableId = fitableId;
        this.invokeContext = invokeContext;
    }

    protected AbstractProxy(ProxyFactory factory, Class<?> genericableClass, Method genericableMethod, String fitableId, InvokeContext invokeContext) {
        this.factory = (ProxyFactory)Validation.notNull((Object)factory, (String)"Owning factory of proxy cannot be null.", (Object[])new Object[0]);
        this.genericableClass = (Class)Validation.notNull(genericableClass, (String)"Genericable class of a proxy cannot be null.", (Object[])new Object[0]);
        this.genericableId = AnnotationUtils.getGenericableId(genericableClass);
        this.invokeContext = invokeContext;
        Method actualGenericableMethod = (Method)ObjectUtils.getIfNull((Object)genericableMethod, () -> AnnotationUtils.getGenericableMethod(this.genericableClass));
        this.parameters = Arrays.asList(ReflectionUtils.getParameters((Executable)actualGenericableMethod));
        this.returnType = actualGenericableMethod.getGenericReturnType();
        this.fitableId = Validation.notBlank((String)fitableId, (String)"Fitable id of a proxy cannot be blank.", (Object[])new Object[0]);
    }

    public boolean isTrustIgnored() {
        return this.containsTag("trustIgnored");
    }

    public boolean isAopIgnored() {
        return this.containsTag("aopIgnored");
    }

    public boolean isMeshIgnored() {
        return this.containsTag("meshIgnored");
    }

    public boolean isLocalOnly() {
        return this.containsTag("localOnly");
    }

    public List<Parameter> getParameters() {
        return Collections.unmodifiableList(this.parameters);
    }

    protected Optional<String> getGenericableClassName() {
        return Optional.ofNullable(this.genericableClass).map(Class::getName);
    }

    public InvokeContext getInvokeContext() {
        return Optional.ofNullable(this.invokeContext).orElseGet(() -> {
            log.warn("Invoke context is null, default context will be used. [genericableId={}]", (Object)this.getGenericableId());
            return InvokeContext.defaultContext();
        });
    }

    private boolean containsTag(String tag) {
        return this.getFactory().getConfigurationLoader().load().genericable(this.getGenericableId()).filter(conf -> conf.containsTag(tag)).isPresent();
    }

    @Generated
    public ProxyFactory getFactory() {
        return this.factory;
    }

    @Generated
    public Class<?> getGenericableClass() {
        return this.genericableClass;
    }

    @Generated
    public String getGenericableId() {
        return this.genericableId;
    }

    @Generated
    public String getFitableId() {
        return this.fitableId;
    }

    @Generated
    public Type getReturnType() {
        return this.returnType;
    }
}

