/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.fitframework.broker.client.proxy.support;

import com.huawei.fit.hakuna.kernel.broker.client.RequestResponseV4;
import com.huawei.fit.hakuna.kernel.broker.client.entity.RequestContext;
import com.huawei.fit.hakuna.kernel.broker.shared.entity.FitResponse;
import com.huawei.fit.hakuna.kernel.registry.listener.MarkFitableAddressStatus;
import com.huawei.fit.hakuna.kernel.registry.shared.entity.Worker;
import com.huawei.fit.hakuna.kernel.shared.entity.Fitable;
import com.huawei.fit.hakuna.shared.entity.Address;
import com.huawei.fitframework.broker.client.InvokeContext;
import com.huawei.fitframework.broker.client.filter.Target;
import com.huawei.fitframework.broker.client.proxy.ProxyFactory;
import com.huawei.fitframework.broker.client.proxy.support.AbstractProxy;
import com.huawei.fitframework.broker.client.util.EndpointUtils;
import com.huawei.fitframework.broker.conf.FitableConfiguration;
import com.huawei.fitframework.broker.conf.GenericableConfiguration;
import com.huawei.fitframework.broker.serialization.GenericVersion;
import com.huawei.fitframework.broker.serialization.MessageSerializer;
import com.huawei.fitframework.broker.serialization.RequestMetadata;
import com.huawei.fitframework.broker.serialization.ResponseMetadata;
import com.huawei.fitframework.broker.serialization.SerializationService;
import com.huawei.fitframework.broker.serialization.TagLengthValues;
import com.huawei.fitframework.broker.serialization.support.DefaultTagLengthValues;
import com.huawei.fitframework.core.common.util.CollectionUtils;
import com.huawei.fitframework.core.common.util.ExceptionUtils;
import com.huawei.fitframework.core.common.util.LazyLoader;
import com.huawei.fitframework.core.common.util.ObjectUtils;
import com.huawei.fitframework.core.common.util.StringUtils;
import com.huawei.fitframework.core.common.util.Validation;
import com.huawei.fitframework.exception.DegradableException;
import com.huawei.fitframework.exception.FitException;
import com.huawei.fitframework.exception.SystemError;
import com.huawei.fitframework.tlv.TlvSerializer;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRemoteProxy
extends AbstractProxy {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractRemoteProxy.class);
    private static final Pattern PROTOCOL_PATTERN = Pattern.compile("^protocol:(\\d+)$");
    private static final int PROTOCOL_GROUP = 1;
    private static final GenericVersion GENERIC_VERSION = GenericVersion.builder().setMajor((byte)1).setMinor((byte)0).setRevision((byte)0).build();
    private static final String FIT_EXCEPTION_TLV_SERIALIZER_ALIAS = "fitExceptionTlvSerializer";
    private final Target target;
    private final int format;
    private final SerializationService serializationService;
    private final MessageSerializer messageSerializer;
    private final LazyLoader<Map<Integer, RequestResponseV4>> protocolMapLoader;

    public AbstractRemoteProxy(ProxyFactory factory, String genericableId, String fitableId, Target target, InvokeContext invokeContext) {
        super(factory, genericableId, fitableId, invokeContext);
        this.target = target;
        this.serializationService = (SerializationService)factory.getCachedBrokerClient().getProxy(SerializationService.class);
        this.format = this.chooseFormat(this.target);
        this.messageSerializer = this.serializationService.require(this.format);
        this.protocolMapLoader = new LazyLoader(this::initSenders);
    }

    public AbstractRemoteProxy(ProxyFactory factory, Class<?> genericableClass, String fitableId, Target target, InvokeContext invokeContext) {
        super(factory, genericableClass, null, fitableId, invokeContext);
        this.target = target;
        this.serializationService = (SerializationService)factory.getCachedBrokerClient().getProxy(SerializationService.class);
        this.format = this.chooseFormat(this.target);
        this.messageSerializer = this.serializationService.require(this.format);
        this.protocolMapLoader = new LazyLoader(this::initSenders);
    }

    public <T> T execute(Object ... args) {
        FitResponse rawResponse;
        ResponseMetadata responseMetadata;
        if (log.isDebugEnabled()) {
            log.debug("Prepare to execute {} proxy. [genericableClass={}, genericableId={}, fitableId={}, target={}]", new Object[]{this.getClass().getSimpleName(), this.getGenericableClassName().orElse(null), this.getGenericableId(), this.getFitableId(), this.target});
        }
        if ((responseMetadata = ResponseMetadata.deserialize((rawResponse = this.requestResponse(this.target, this.getRequestMetadataBytes(this.format), this.serializeRequest(args))).getMetadata())).getCode() == 0) {
            if (log.isDebugEnabled()) {
                log.debug("Execute {} proxy successfully. [genericableClass={}, genericableId={}, fitableId={}, target={}]", new Object[]{this.getClass().getSimpleName(), this.getGenericableClassName().orElse(null), this.getGenericableId(), this.getFitableId(), this.target});
            }
            return this.deserializeResponse(rawResponse.getData());
        }
        if (responseMetadata.isDegradationException()) {
            log.warn("Fail to execute {} proxy, throw degradation exception. [genericableClass={}, genericableId={}, fitableId={}, target={}, code={}, message={}]", new Object[]{this.getClass().getSimpleName(), this.getGenericableClassName().orElse(null), this.getGenericableId(), this.getFitableId(), this.target, responseMetadata.getCode(), responseMetadata.getMessage()});
            throw new DegradableException(this.getGenericableId(), this.getFitableId(), responseMetadata.getCode(), responseMetadata.getMessage());
        }
        TlvSerializer tlvSerializer = (TlvSerializer)this.getFactory().getBrokerClient().getProxyByAlias(TlvSerializer.class, FIT_EXCEPTION_TLV_SERIALIZER_ALIAS);
        Map properties = (Map)tlvSerializer.deserialize(responseMetadata.getTagValues());
        log.warn("Fail to execute {} proxy, throw fit exception. [genericableClass={}, genericableId={}, fitableId={}, target={}, code={}, message={}]", new Object[]{this.getClass().getSimpleName(), this.getGenericableClassName().orElse(null), this.getGenericableId(), this.getFitableId(), this.target, responseMetadata.getCode(), responseMetadata.getMessage()});
        throw new FitException(this.getGenericableId(), this.getFitableId(), responseMetadata.getCode(), responseMetadata.getMessage(), null, properties);
    }

    private FitResponse requestResponse(Target target, byte[] metadataBytes, byte[] requestBytes) {
        Target.Endpoint endpoint = (Target.Endpoint)target.getEndpoints().iterator().next();
        Validation.notNull((Object)endpoint.getProtocol(), (String)"No protocol in endpoint.", (Object[])new Object[0]);
        RequestResponseV4 sender = this.getSender(endpoint.getProtocol()).orElseThrow(() -> new IllegalStateException(StringUtils.format((String)"No available fitable matched at localhost. [genericableClass={0}, genericableId={1}, protocol={2}]", (Object[])new Object[]{RequestResponseV4.class.getName(), "47a8ec8a3d8f46daa1f2d751ad7d6d16", endpoint.getProtocol()})));
        try {
            Address address = Address.builder().host(target.getHost()).port(Integer.valueOf(endpoint.getPort())).workerId(target.getWorkerId()).build();
            InvokeContext invokeContext = (InvokeContext)ObjectUtils.nullIf((Object)this.getInvokeContext(), (Object)InvokeContext.defaultContext());
            RequestContext requestContext = RequestContext.builder().timeout(Long.valueOf(invokeContext.timeUnit().toMillis(invokeContext.timeout()))).build();
            return sender.process(address, metadataBytes, requestBytes, requestContext);
        }
        catch (FitException fitException) {
            if (SystemError.fromCode((int)fitException.getCode()) == SystemError.Category.NETWORK) {
                this.markAddressStatus(target);
            }
            throw fitException;
        }
    }

    private Optional<RequestResponseV4> getSender(Integer protocol) {
        return Optional.ofNullable(((Map)this.protocolMapLoader.get()).get(protocol));
    }

    private Map<Integer, RequestResponseV4> initSenders() {
        List localFitableIds = this.getFactory().listLocalFitableIds("47a8ec8a3d8f46daa1f2d751ad7d6d16");
        if (CollectionUtils.isEmpty((Collection)localFitableIds)) {
            return new HashMap<Integer, RequestResponseV4>();
        }
        GenericableConfiguration genericableConfiguration = (GenericableConfiguration)this.getFactory().getConfigurationLoader().load().genericable("47a8ec8a3d8f46daa1f2d751ad7d6d16").orElseThrow(() -> new IllegalStateException(StringUtils.format((String)"No genericable configuration. [genericableClass={0}, genericableId={1}]", (Object[])new Object[]{RequestResponseV4.class.getName(), "47a8ec8a3d8f46daa1f2d751ad7d6d16"})));
        HashMap<Integer, RequestResponseV4> senders = new HashMap<Integer, RequestResponseV4>();
        for (String localFitableId : localFitableIds) {
            Optional opProtocol = genericableConfiguration.fitable(localFitableId).map(FitableConfiguration::tags).flatMap(AbstractRemoteProxy::chooseProtocol);
            if (!opProtocol.isPresent()) continue;
            senders.put((Integer)opProtocol.get(), (RequestResponseV4)this.getFactory().getBrokerClient().getProxyByFitableId(RequestResponseV4.class, localFitableId));
        }
        return senders;
    }

    private static Optional<Integer> chooseProtocol(Collection<String> tags) {
        for (String tag : tags) {
            Matcher matcher = PROTOCOL_PATTERN.matcher(tag);
            if (!matcher.matches()) continue;
            return Optional.of(Integer.valueOf(matcher.group(1)));
        }
        return Optional.empty();
    }

    private void markAddressStatus(Target target) {
        Fitable fitable = Fitable.builder().genericableId(this.getGenericableId()).genericableVersion("1.0.0").fitableId(this.getFitableId()).build();
        Worker worker = EndpointUtils.toWorker(target);
        try {
            MarkFitableAddressStatus markFitableAddressStatus = (MarkFitableAddressStatus)this.getFactory().getBrokerClient().getProxyByDefault(MarkFitableAddressStatus.class);
            markFitableAddressStatus.process(fitable, worker, Boolean.valueOf(false));
        }
        catch (Exception exception) {
            Target.Endpoint endpoint = (Target.Endpoint)target.getEndpoints().iterator().next();
            log.warn("mark fitable address status failed. [fitable(genericId={}, fitableId={}); address(host={}, port={}, protocol={}); status={}; reason={}]", new Object[]{fitable.getGenericableId(), fitable.getFitableId(), target.getHost(), endpoint.getPort(), endpoint.getProtocol(), false, ExceptionUtils.getReason((Throwable)exception)});
        }
    }

    private byte[] getRequestMetadataBytes(int format) {
        byte[] serialized = RequestMetadata.builder().setVersion((short)2).setGenericVersion(GENERIC_VERSION).setDataFormat(AbstractRemoteProxy.valueFormat(format)).setGenericId(this.getGenericableId()).setFitId(this.getFitableId()).setTagLengthValues(this.getTlvFromSerializers()).build().serialize();
        log.info("Metadata size: {}.", (Object)(serialized == null ? 0 : serialized.length));
        return serialized;
    }

    private static byte valueFormat(int format) {
        return (byte)(format & 0xFF);
    }

    private TagLengthValues getTlvFromSerializers() {
        Map<Integer, byte[]> tlvMaps = this.getFactory().getBrokerClient().list(TlvSerializer.class).values().stream().map(TlvSerializer.class::cast).map(tlvSerializer -> tlvSerializer.serialize(null)).flatMap(tlvMap -> tlvMap.entrySet().stream()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (val1, val2) -> {
            throw new IllegalStateException(StringUtils.format((String)"Duplicated tlv tag", (Object[])new Object[0]));
        }));
        DefaultTagLengthValues result = new DefaultTagLengthValues();
        result.putTags(tlvMaps);
        return result;
    }

    private int chooseFormat(Target target) {
        return this.computeAvailableFormats(target).iterator().next();
    }

    protected abstract Set<Integer> computeAvailableFormats(Target var1);

    protected Set<Integer> getSupportedFormats() {
        return this.serializationService.getSupportedFormats(this.getGenericableId());
    }

    protected abstract byte[] serializeRequest(Object[] var1);

    protected abstract <T> T deserializeResponse(byte[] var1);

    @Generated
    public Target getTarget() {
        return this.target;
    }

    @Generated
    public MessageSerializer getMessageSerializer() {
        return this.messageSerializer;
    }
}

