/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.fitframework.broker.client.proxy.support;

import com.huawei.fitframework.aspect.ProxyCallType;
import com.huawei.fitframework.broker.FitableNotFoundException;
import com.huawei.fitframework.broker.client.BrokerClient;
import com.huawei.fitframework.broker.client.InvokeContext;
import com.huawei.fitframework.broker.client.filter.Target;
import com.huawei.fitframework.broker.client.proxy.Proxy;
import com.huawei.fitframework.broker.client.proxy.ProxyFactory;
import com.huawei.fitframework.broker.client.proxy.ProxyRepository;
import com.huawei.fitframework.broker.client.proxy.support.ConcreteRemoteProxy;
import com.huawei.fitframework.broker.client.proxy.support.DefaultProxyRepository;
import com.huawei.fitframework.broker.client.proxy.support.GenericRemoteProxy;
import com.huawei.fitframework.broker.client.proxy.support.LocalProxyResolver;
import com.huawei.fitframework.broker.client.proxy.support.ProxyRepositoryComposite;
import com.huawei.fitframework.broker.client.proxy.support.decorator.AspectDecorator;
import com.huawei.fitframework.broker.client.proxy.support.decorator.RetryDecorator;
import com.huawei.fitframework.broker.client.support.CachedBrokerClient;
import com.huawei.fitframework.broker.client.support.DefaultBrokerClient;
import com.huawei.fitframework.broker.client.util.AnnotationUtils;
import com.huawei.fitframework.broker.conf.ConfigurationLoader;
import com.huawei.fitframework.broker.conf.support.DefaultConfigurationLoader;
import com.huawei.fitframework.conf.Config;
import com.huawei.fitframework.core.common.util.ReflectionUtils;
import com.huawei.fitframework.core.common.util.StringUtils;
import com.huawei.fitframework.core.common.util.Validation;
import com.huawei.fitframework.exception.NoGenericableClassException;
import com.huawei.fitframework.ioc.ComponentBrief;
import com.huawei.fitframework.ioc.ComponentContainer;
import com.huawei.fitframework.ioc.ComponentRegistry;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultProxyFactory
implements ProxyFactory {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultProxyFactory.class);
    private final Config config;
    private final BrokerClient brokerClient;
    private final BrokerClient cachedBrokerClient;
    private final ConfigurationLoader configurationLoader;
    private final ComponentContainer container;
    private final Map<String, Class<?>> genericableClasses;
    private final ProxyRepositoryComposite localProxyRepository;
    private final Map<String, Consumer<ComponentBrief>> componentRegisteredObservers;

    public DefaultProxyFactory(ComponentContainer container, Config config) {
        this.container = (ComponentContainer)Validation.notNull((Object)container, (String)"Container of a proxy factory cannot be null.", (Object[])new Object[0]);
        this.config = (Config)Validation.notNull((Object)config, (String)"Configuration of a proxy factory cannot be null.", (Object[])new Object[0]);
        this.brokerClient = new DefaultBrokerClient(container, this, config);
        this.cachedBrokerClient = new CachedBrokerClient(this.brokerClient);
        this.configurationLoader = new DefaultConfigurationLoader();
        DefaultProxyRepository localProxyBaseRepository = new DefaultProxyRepository("proxy-repository:local");
        this.localProxyRepository = new ProxyRepositoryComposite(localProxyBaseRepository);
        container.getRegistry().observeComponentRegistered((Consumer)new ComponentRegisteredObserver(container.getRegistry()));
        this.genericableClasses = new ConcurrentHashMap();
        this.componentRegisteredObservers = new ConcurrentHashMap<String, Consumer<ComponentBrief>>();
        this.container.observeRegistryInstalled(this::onComponentRegistryInstalled);
        this.container.observeRegistryUninstalled(this::onComponentRegistryUninstalled);
    }

    private void onComponentRegistryInstalled(ComponentRegistry registry) {
        DefaultProxyRepository repository = new DefaultProxyRepository(registry.getName());
        this.localProxyRepository.install(repository);
        ComponentRegisteredObserver observer = new ComponentRegisteredObserver(registry);
        this.componentRegisteredObservers.put(registry.getName(), observer);
        registry.observeComponentRegistered((Consumer)observer);
    }

    private void onComponentRegistryUninstalled(ComponentRegistry registry) {
        this.localProxyRepository.getChildren().stream().filter(child -> StringUtils.equals((String)child.getName(), (String)registry.getName())).findAny().ifPresent(this.localProxyRepository::uninstall);
        Consumer<ComponentBrief> observer = this.componentRegisteredObservers.remove(registry.getName());
        if (observer != null) {
            registry.unobserveComponentRegistered(observer);
        }
    }

    private void onComponentRegistered(ComponentRegistry registry, ComponentBrief brief) {
        if (Objects.equals(registry.getName(), "component-container:default-registry:composite")) {
            this.resolveLocalProxies(this.localProxyRepository, brief);
        } else {
            this.localProxyRepository.getChildren().stream().filter(child -> StringUtils.equals((String)child.getName(), (String)registry.getName())).findAny().ifPresent(repository -> this.resolveLocalProxies((ProxyRepository)repository, brief));
        }
    }

    private void resolveLocalProxies(ProxyRepository repository, ComponentBrief brief) {
        LocalProxyResolver resolver = LocalProxyResolver.factory().create(this.container, repository.getRegistry());
        for (Class objectClass = brief.getComponentClass(); objectClass != null && !Objects.equals(objectClass, Object.class); objectClass = objectClass.getSuperclass()) {
            Method[] methods;
            for (Method method : methods = ReflectionUtils.getDeclaredMethods((Class)objectClass)) {
                resolver.resolve(brief, method);
            }
        }
    }

    public void registerGenericable(Class<?> genericableClass) {
        this.genericableClasses.put(AnnotationUtils.getGenericableId(genericableClass), genericableClass);
    }

    public Optional<ProxyRepository> getLocalProxyRepository(String name) {
        if (Objects.equals(name, this.localProxyRepository.getBaseRepository().getName())) {
            return Optional.of(this.localProxyRepository.getBaseRepository());
        }
        return this.localProxyRepository.getChild(name);
    }

    public List<ProxyRepository> getLocalProxyRepositories() {
        return this.localProxyRepository.getChildren();
    }

    public Proxy getRemoteProxy(String genericableId, String fitableId, Target target, InvokeContext context) {
        Class<?> genericableClass = this.getGenericableClass(genericableId);
        ConcreteRemoteProxy concreteRemoteProxy = new ConcreteRemoteProxy((ProxyFactory)this, genericableClass, fitableId, target, context);
        return this.decorate(concreteRemoteProxy, ProxyCallType.REMOTE);
    }

    public Proxy getRemoteGenericProxy(String genericableId, String fitableId, Target target, InvokeContext invokeContext) {
        GenericRemoteProxy genericInvoker = new GenericRemoteProxy((ProxyFactory)this, genericableId, fitableId, target, invokeContext);
        return this.decorate(genericInvoker, ProxyCallType.REMOTE);
    }

    public Proxy getLocalProxy(String genericableId, String fitableId) {
        return this.localProxyRepository.get(genericableId, fitableId).map(localProxy -> this.decorate((Proxy)localProxy, ProxyCallType.LOCAL)).orElseThrow(() -> new FitableNotFoundException(genericableId, fitableId, StringUtils.format((String)"No local proxy. [genericableId={0}, fitableId={1}]", (Object[])new Object[]{genericableId, fitableId})));
    }

    public Class<?> getGenericableClass(String genericableId) {
        Class<?> genericableClass = this.genericableClasses.get(genericableId);
        if (genericableClass == null) {
            throw new NoGenericableClassException(genericableId, "Unrecognized genericable id: " + genericableId);
        }
        return genericableClass;
    }

    public List<Class<?>> listGenericableClasses() {
        return Collections.unmodifiableList(new ArrayList(this.genericableClasses.values()));
    }

    public Proxy getLocalProxy(Class<?> genericableClass, String fitableId) {
        return this.getLocalProxy(AnnotationUtils.getGenericableId(genericableClass), fitableId);
    }

    public boolean contains(String genericableId) {
        return this.genericableClasses.containsKey(genericableId);
    }

    private Proxy decorate(Proxy proxy, ProxyCallType callType) {
        Proxy aopDecorated = AspectDecorator.decorate(proxy, callType);
        return RetryDecorator.decorate(aopDecorated);
    }

    @Generated
    public Config getConfig() {
        return this.config;
    }

    @Generated
    public BrokerClient getBrokerClient() {
        return this.brokerClient;
    }

    @Generated
    public BrokerClient getCachedBrokerClient() {
        return this.cachedBrokerClient;
    }

    @Generated
    public ConfigurationLoader getConfigurationLoader() {
        return this.configurationLoader;
    }

    private class ComponentRegisteredObserver
    implements Consumer<ComponentBrief> {
        private final ComponentRegistry registry;

        private ComponentRegisteredObserver(ComponentRegistry registry) {
            this.registry = registry;
        }

        @Override
        public void accept(ComponentBrief brief) {
            DefaultProxyFactory.this.onComponentRegistered(this.registry, brief);
        }
    }
}

