/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.fitframework.broker.client.proxy.support;

import com.huawei.fitframework.broker.BundleIdentity;
import com.huawei.fitframework.broker.client.proxy.Proxy;
import com.huawei.fitframework.broker.client.proxy.ProxyRepository;
import com.huawei.fitframework.core.common.util.LockUtils;
import com.huawei.fitframework.core.common.util.Validation;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultProxyRepository
implements ProxyRepository {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultProxyRepository.class);
    private final String name;
    private final Map<String, Map<String, Proxy>> proxies;
    private final Lock lock;

    public DefaultProxyRepository(String name) {
        this.name = name;
        this.proxies = new ConcurrentHashMap<String, Map<String, Proxy>>();
        this.lock = LockUtils.newReentrantLock();
    }

    public List<BundleIdentity> getFitableIdentities() {
        return this.proxies.entrySet().stream().flatMap(entry -> this.toLocalBundleIdentities((String)entry.getKey(), (Map)entry.getValue()).stream()).collect(Collectors.toList());
    }

    private List<BundleIdentity> toLocalBundleIdentities(String genericId, Map<String, Proxy> fitIdProxyMap) {
        return fitIdProxyMap.keySet().stream().map(fitableId -> new BundleIdentity(genericId, fitableId)).collect(Collectors.toList());
    }

    private void addProxy(String genericableId, String fitableId, Proxy proxy) {
        if (proxy == null) {
            this.removeProxy(genericableId, fitableId);
        } else {
            log.debug("Add local proxy of fitable. [genericableId={}, fitableId={}]", (Object)genericableId, (Object)fitableId);
            LockUtils.synchronize((Lock)this.lock, () -> {
                Map fitables = this.proxies.computeIfAbsent(genericableId, key -> new ConcurrentHashMap());
                fitables.put(fitableId, proxy);
            });
        }
    }

    private void removeProxy(String genericableId, String fitableId) {
        log.debug("Remove local proxy of fitable. [genericableId={}, fitableId={}]", (Object)genericableId, (Object)fitableId);
        LockUtils.synchronize((Lock)this.lock, () -> {
            Map<String, Proxy> fitables = this.proxies.get(genericableId);
            if (fitables == null) {
                return;
            }
            fitables.remove(fitableId);
            if (fitables.isEmpty()) {
                this.proxies.remove(genericableId);
            }
        });
    }

    public ProxyRepository.Registry getRegistry() {
        return (genericableId, fitableId, proxy) -> {
            Validation.notNull((Object)genericableId, (String)"Genericable id of proxy to store cannot be null.", (Object[])new Object[0]);
            Validation.notNull((Object)fitableId, (String)"Fitable id of proxy to store cannot be null.", (Object[])new Object[0]);
            this.addProxy(genericableId, fitableId, proxy);
        };
    }

    public Optional<Proxy> get(String genericableId, String fitableId) {
        if (genericableId == null || fitableId == null) {
            return Optional.empty();
        }
        Map<String, Proxy> fitableProxies = this.proxies.get(genericableId);
        if (fitableProxies == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(fitableProxies.get(fitableId));
    }

    public Proxy get(String genericableId, String fitableId, Supplier<Proxy> factory) {
        Validation.notNull((Object)genericableId, (String)"Genericable id of proxy to lookup cannot be null.", (Object[])new Object[0]);
        Validation.notNull((Object)fitableId, (String)"Fitable id of proxy to lookup cannot be null.", (Object[])new Object[0]);
        Validation.notNull(factory, (String)"The factory to create proxy when not found cannot be null.", (Object[])new Object[0]);
        Map fitableMap = this.proxies.computeIfAbsent(genericableId, key -> new ConcurrentHashMap());
        return (Proxy)LockUtils.synchronize((Lock)this.lock, () -> fitableMap.computeIfAbsent(fitableId, arg_0 -> DefaultProxyRepository.lambda$null$7((Supplier)factory, arg_0)));
    }

    @Generated
    public String getName() {
        return this.name;
    }

    private static /* synthetic */ Proxy lambda$null$7(Supplier factory, String key) {
        return (Proxy)factory.get();
    }
}

