/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.fitframework.broker.client.proxy.support;

import com.huawei.fitframework.broker.NoAvailableFormatException;
import com.huawei.fitframework.broker.client.InvokeContext;
import com.huawei.fitframework.broker.client.filter.Target;
import com.huawei.fitframework.broker.client.proxy.ProxyFactory;
import com.huawei.fitframework.broker.client.proxy.support.AbstractRemoteProxy;
import com.huawei.fitframework.core.common.util.CollectionUtils;
import com.huawei.fitframework.core.common.util.StringUtils;
import com.huawei.fitframework.core.common.util.Validation;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenericRemoteProxy
extends AbstractRemoteProxy {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GenericRemoteProxy.class);
    private static final Charset DEFAULT_CHARSET = StandardCharsets.UTF_8;
    private static final int JSON_SERIALIZER_FORMAT = 1;
    private static final String JSON_ARRAY_DELIMITER = ",";
    private static final String JSON_ARRAY_PREFIX = "[";
    private static final String JSON_ARRAY_SUFFIX = "]";

    public GenericRemoteProxy(ProxyFactory factory, String genericableId, String fitableId, Target target, InvokeContext invokeContext) {
        super(factory, genericableId, fitableId, target, invokeContext);
    }

    @Override
    protected Set<Integer> computeAvailableFormats(Target target) {
        List requiredFormats = target.getFormats();
        if (!requiredFormats.contains(1)) {
            throw new NoAvailableFormatException(this.getGenericableId(), this.getFitableId(), StringUtils.format((String)"No available format at target endpoint. [endpoint={0}:{1}, genericableId={2}, fitableId={3}, requiredFormats={4}]", (Object[])new Object[]{target.getHost(), target.getEndpoints(), this.getGenericableId(), this.getFitableId(), CollectionUtils.toString((Iterable)target.getFormats())}));
        }
        Set<Integer> supportedFormats = this.getSupportedFormats();
        if (!supportedFormats.contains(1)) {
            throw new NoAvailableFormatException(this.getGenericableId(), this.getFitableId(), StringUtils.format((String)"No available format at localhost. [endpoint={0}:{1}, genericableId={2}, fitableId={3}, supportedFormats={4}]", (Object[])new Object[]{target.getHost(), target.getEndpoints(), this.getGenericableId(), this.getFitableId(), CollectionUtils.toString(supportedFormats)}));
        }
        return Collections.singleton(1);
    }

    @Override
    protected byte[] serializeRequest(Object[] arguments) {
        Validation.notNull((Object)arguments, (String)"Arguments is null.", (Object[])new Object[0]);
        for (int i = 0; i < arguments.length; ++i) {
            Validation.isTrue((boolean)(arguments[i] instanceof String), (String)"Argument[{0}] is not a valid Json String. [argument[{0}]={1}].", (Object[])new Object[]{i, arguments[i]});
        }
        String jsonArray = Stream.of(arguments).map(String::valueOf).collect(Collectors.joining(JSON_ARRAY_DELIMITER, JSON_ARRAY_PREFIX, JSON_ARRAY_SUFFIX));
        return jsonArray.getBytes(DEFAULT_CHARSET);
    }

    @Override
    protected <T> T deserializeResponse(byte[] data) {
        if (data == null || data.length <= 0) {
            return null;
        }
        return (T)new String(data, DEFAULT_CHARSET);
    }

    public boolean isGenericProxy() {
        return true;
    }
}

