/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.fitframework.broker.client.proxy.support;

import com.huawei.fitframework.broker.client.InvokeContext;
import com.huawei.fitframework.broker.client.proxy.ProxyFactory;
import com.huawei.fitframework.broker.client.proxy.support.AbstractProxy;
import com.huawei.fitframework.broker.client.proxy.support.FitableType;
import com.huawei.fitframework.core.common.exception.MethodInvocationException;
import com.huawei.fitframework.core.common.util.LazyLoader;
import com.huawei.fitframework.core.common.util.ReflectionUtils;
import com.huawei.fitframework.core.common.util.StringUtils;
import com.huawei.fitframework.core.common.util.Validation;
import com.huawei.fitframework.exception.FitException;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalProxy
extends AbstractProxy {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LocalProxy.class);
    private final Method method;
    private final LazyLoader<Object> componentLoader;
    private final FitableType fitableType;

    public LocalProxy(ProxyFactory factory, Class<?> genericableClass, String fitableId, Supplier<Object> componentSupplier, Method method, FitableType fitableType) {
        super(factory, genericableClass, method, fitableId, InvokeContext.defaultContext());
        Validation.notNull(componentSupplier, (String)"The component supplier of local fitable cannot be null.", (Object[])new Object[0]);
        this.componentLoader = new LazyLoader(componentSupplier);
        this.method = (Method)Validation.notNull((Object)method, (String)"The method of local fitable cannot be null.", (Object[])new Object[0]);
        this.fitableType = (FitableType)((Object)Validation.notNull((Object)((Object)fitableType), (String)"Type of a local fitable cannot be null.", (Object[])new Object[0]));
    }

    public final FitableType getFitableType() {
        return this.fitableType;
    }

    public boolean isGenericProxy() {
        return false;
    }

    public <T> T execute(Object ... args) {
        Object result;
        this.validateParams(args);
        Object component = this.componentLoader.get();
        ClassLoader currentClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(component.getClass().getClassLoader());
            result = ReflectionUtils.invoke((Object)component, (Method)this.method, (Object[])args);
        }
        catch (MethodInvocationException e) {
            this.handleMethodInvocationException(e);
            throw e;
        }
        finally {
            Thread.currentThread().setContextClassLoader(currentClassLoader);
        }
        return (T)result;
    }

    private void validateParams(Object[] args) {
        Parameter[] parameters = this.method.getParameters();
        int actualArgLen = args == null ? 0 : args.length;
        int expectedArgLen = parameters.length;
        Validation.equals((Object)actualArgLen, (Object)expectedArgLen, () -> new IllegalArgumentException(StringUtils.format((String)"Argument number mismatch. [argumentTypes={0}]", (Object[])new Object[]{Stream.of(parameters).map(Parameter::getType).map(Class::getName).collect(Collectors.toList())})));
        for (int i = 0; i < actualArgLen; ++i) {
            Object actualArg = args[i];
            if (actualArg == null || parameters[i].getType().isAssignableFrom(actualArg.getClass())) continue;
            throw new IllegalArgumentException(StringUtils.format((String)"Argument[{0}] mismatch. [expectedArgumentType={1}, actualArgumentType={2}]", (Object[])new Object[]{i, parameters[i].getType().getName(), actualArg.getClass().getName()}));
        }
    }

    private void handleMethodInvocationException(MethodInvocationException exception) {
        Throwable cause = exception.getCause();
        if (cause instanceof FitException) {
            this.handleFitException((FitException)cause);
        }
    }

    private void handleFitException(FitException cause) {
        boolean ret = cause.associate(this.getGenericableId(), this.getFitableId());
        if (!ret) {
            log.warn("Fail to associate fitable info to current fit exception. [oldGenericableId={}, oldFitableId={}, newGenericableId={}, newFitableId={}]", new Object[]{cause.getGenericableId(), cause.getFitableId(), this.getGenericableId(), this.getFitableId()});
        }
    }

    @Override
    public boolean isTrustIgnored() {
        if (!Objects.equals((Object)this.getFitableType(), (Object)FitableType.PLAIN)) {
            return true;
        }
        return super.isTrustIgnored();
    }

    @Override
    public boolean isAopIgnored() {
        if (!Objects.equals((Object)this.getFitableType(), (Object)FitableType.PLAIN)) {
            return true;
        }
        return super.isAopIgnored();
    }

    @Override
    public boolean isMeshIgnored() {
        if (!Objects.equals((Object)this.getFitableType(), (Object)FitableType.PLAIN)) {
            return true;
        }
        return super.isMeshIgnored();
    }

    public String toString() {
        return StringUtils.format((String)"LocalProxy. [component={0}, method={1}, fitableType={2}, genericableClass={3}, genericableId={4}, fitableId={5}]", (Object[])new Object[]{this.componentLoader.get().getClass().getName(), this.method.getName(), this.fitableType, this.getGenericableClass().getName(), this.getGenericableId(), this.getFitableId()});
    }
}

