/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.fitframework.broker.client.proxy.support;

import com.huawei.fitframework.annotation.FitRouting;
import com.huawei.fitframework.annotation.FitTrust;
import com.huawei.fitframework.annotation.Fitable;
import com.huawei.fitframework.broker.client.proxy.Proxy;
import com.huawei.fitframework.broker.client.proxy.ProxyFactory;
import com.huawei.fitframework.broker.client.proxy.ProxyRepository;
import com.huawei.fitframework.broker.client.proxy.support.FitableType;
import com.huawei.fitframework.broker.client.proxy.support.LocalProxy;
import com.huawei.fitframework.core.common.util.LazyLoader;
import com.huawei.fitframework.core.common.util.ObjectUtils;
import com.huawei.fitframework.core.common.util.StringUtils;
import com.huawei.fitframework.core.common.util.Validation;
import com.huawei.fitframework.ioc.ComponentBrief;
import com.huawei.fitframework.ioc.ComponentContainer;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@FunctionalInterface
public interface LocalProxyResolver {
    public boolean resolve(ComponentBrief var1, Method var2);

    public static Factory factory() {
        return Factory.DEFAULT;
    }

    public static LocalProxyResolver combine(LocalProxyResolver ... resolvers) {
        if (resolvers == null) {
            return (supplier, method) -> false;
        }
        List actualResolvers = Arrays.stream(resolvers).filter(Objects::nonNull).collect(Collectors.toList());
        return (brief, method) -> {
            for (LocalProxyResolver resolver : actualResolvers) {
                if (!resolver.resolve(brief, method)) continue;
                return true;
            }
            return false;
        };
    }

    public static class ByFitTrust
    extends ByAnnotation<FitTrust> {
        @Generated
        private static final Logger log = LoggerFactory.getLogger(ByFitTrust.class);

        public ByFitTrust(ComponentContainer container, ProxyRepository.Registry store) {
            super(container, store);
        }

        @Override
        protected Class<FitTrust> getAnnotation() {
            return FitTrust.class;
        }

        @Override
        protected Class<?> getGenericableClass(FitTrust annotation) {
            return annotation.generic();
        }

        @Override
        protected String getFitableId(ComponentBrief brief, Method method) {
            if (!method.isAnnotationPresent(FitTrust.class)) {
                throw new IllegalStateException(StringUtils.format((String)"@FitTrust is not present for method[{0}].", (Object[])new Object[]{method.getName()}));
            }
            String trustId = method.getAnnotation(FitTrust.class).id();
            if (StringUtils.isNotBlank((String)trustId)) {
                return trustId;
            }
            log.warn(StringUtils.format((String)"method[{0}] id is blank.", (Object[])new Object[]{method.getName()}));
            return super.getFitableId(brief, method);
        }

        @Override
        protected FitableType getFitableType() {
            return FitableType.TRUST;
        }
    }

    public static class ByFitRouting
    extends ByAnnotation<FitRouting> {
        public ByFitRouting(ComponentContainer container, ProxyRepository.Registry store) {
            super(container, store);
        }

        @Override
        protected Class<FitRouting> getAnnotation() {
            return FitRouting.class;
        }

        @Override
        protected Class<?> getGenericableClass(FitRouting annotation) {
            return annotation.generic();
        }

        @Override
        protected FitableType getFitableType() {
            return FitableType.ROUTING;
        }
    }

    public static class ByFitable
    extends ByAnnotation<Fitable> {
        @Generated
        private static final Logger log = LoggerFactory.getLogger(ByFitable.class);

        public ByFitable(ComponentContainer container, ProxyRepository.Registry store) {
            super(container, store);
        }

        @Override
        protected Class<Fitable> getAnnotation() {
            return Fitable.class;
        }

        @Override
        protected Class<?> getGenericableClass(Fitable annotation) {
            return annotation.generic();
        }

        @Override
        protected FitableType getFitableType() {
            return FitableType.PLAIN;
        }

        @Override
        protected String getFitableId(ComponentBrief brief, Method method) {
            if (!method.isAnnotationPresent(Fitable.class)) {
                throw new IllegalStateException(StringUtils.format((String)"@Fitable is not present for method[{0}].", (Object[])new Object[]{method.getName()}));
            }
            String fitableId = method.getAnnotation(Fitable.class).id();
            if (StringUtils.isNotBlank((String)fitableId)) {
                return fitableId;
            }
            log.warn(StringUtils.format((String)"method[{0}] id is blank.", (Object[])new Object[]{method.getName()}));
            return super.getFitableId(brief, method);
        }
    }

    public static abstract class ByAnnotation<T extends Annotation>
    implements LocalProxyResolver {
        private final ComponentContainer container;
        private final LazyLoader<ProxyFactory> factory;
        private final ProxyRepository.Registry store;

        public ByAnnotation(ComponentContainer container, ProxyRepository.Registry store) {
            this.container = (ComponentContainer)Validation.notNull((Object)container, (String)"Container of a local proxy resolver cannot be null.", (Object[])new Object[0]);
            this.store = (ProxyRepository.Registry)Validation.notNull((Object)store, (String)"The store to register local proxy cannot be null.", (Object[])new Object[0]);
            this.factory = new LazyLoader(() -> (ProxyFactory)this.container.require(ProxyFactory.class, new Object[0]));
        }

        private ProxyFactory getFactory() {
            return (ProxyFactory)this.factory.get();
        }

        protected abstract Class<T> getAnnotation();

        protected abstract Class<?> getGenericableClass(T var1);

        protected String getFitableId(ComponentBrief brief, Method method) {
            return brief.getComponentClass().getName() + '.' + method.getName();
        }

        protected abstract FitableType getFitableType();

        @Override
        public boolean resolve(ComponentBrief brief, Method method) {
            Validation.notNull((Object)brief, (String)"Brief of component to resolve local proxy cannot be null.", (Object[])new Object[0]);
            Validation.notNull((Object)method, (String)"Method to resolve local proxy cannot be null.", (Object[])new Object[0]);
            T annotation = method.getDeclaredAnnotation(this.getAnnotation());
            if (annotation == null) {
                return false;
            }
            Class<?> genericableClass = this.getGenericableClass(annotation);
            String fitableId = this.getFitableId(brief, method);
            LocalProxy proxy = new LocalProxy(this.getFactory(), genericableClass, fitableId, () -> this.container.require(brief.getComponentClass(), new Object[0]), method, this.getFitableType());
            this.store.store(proxy.getGenericableId(), fitableId, (Proxy)proxy);
            this.getFactory().registerGenericable(genericableClass);
            return true;
        }
    }

    @FunctionalInterface
    public static interface Factory {
        public static final Factory DEFAULT = Factory.combine(ByFitable::new, ByFitRouting::new, ByFitTrust::new);

        public LocalProxyResolver create(ComponentContainer var1, ProxyRepository.Registry var2);

        public static Factory combine(Factory ... factories) {
            List actualFactories = Arrays.stream((Object[])ObjectUtils.nullIf((Object)factories, (Object)new Factory[0])).filter(Objects::nonNull).collect(Collectors.toList());
            return (container, store) -> {
                LocalProxyResolver[] resolvers = (LocalProxyResolver[])actualFactories.stream().map(factory -> factory.create(container, store)).toArray(LocalProxyResolver[]::new);
                return LocalProxyResolver.combine(resolvers);
            };
        }
    }
}

