/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.fitframework.broker.client.proxy.support;

import com.huawei.fitframework.broker.BundleIdentity;
import com.huawei.fitframework.broker.client.proxy.Proxy;
import com.huawei.fitframework.broker.client.proxy.ProxyRepository;
import com.huawei.fitframework.core.common.util.LockUtils;
import com.huawei.fitframework.core.common.util.StringUtils;
import com.huawei.fitframework.core.common.util.Validation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ProxyRepositoryComposite
implements ProxyRepository {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ProxyRepositoryComposite.class);
    private final ProxyRepository baseRepository;
    private final List<ProxyRepository> repositories;
    private final ReadWriteLock lock;

    ProxyRepositoryComposite(ProxyRepository baseRepository) {
        this.baseRepository = (ProxyRepository)Validation.notNull((Object)baseRepository, (String)"Base repository of composite cannot be null.", (Object[])new Object[0]);
        this.repositories = new ArrayList<ProxyRepository>();
        this.lock = LockUtils.newReentrantReadWriteLock();
    }

    ProxyRepository getBaseRepository() {
        return this.baseRepository;
    }

    void install(ProxyRepository repository) {
        Validation.notNull((Object)repository, (String)"Proxy repository to install cannot be null.", (Object[])new Object[0]);
        LockUtils.synchronize((Lock)this.lock.writeLock(), () -> {
            this.getChild(repository.getName()).ifPresent(this::uninstall);
            log.debug("Install proxy repository. [name={}]", (Object)repository.getName());
            this.repositories.add(repository);
        });
    }

    void uninstall(ProxyRepository repository) {
        Validation.notNull((Object)repository, (String)"Proxy repository to uninstall cannot be null.", (Object[])new Object[0]);
        LockUtils.synchronize((Lock)this.lock.writeLock(), () -> {
            int index = this.repositories.indexOf(repository);
            if (index < 0) {
                log.debug("The proxy repository to uninstall not exists. [name={}]", (Object)repository.getName());
            } else {
                log.debug("Uninstall proxy repository. [name={}]", (Object)repository.getName());
                this.repositories.remove(index);
            }
        });
    }

    List<ProxyRepository> getChildren() {
        return Collections.unmodifiableList(this.repositories);
    }

    Optional<ProxyRepository> getChild(String name) {
        return (Optional)LockUtils.synchronize((Lock)this.lock.readLock(), () -> this.repositories.stream().filter(repository -> StringUtils.equals((String)repository.getName(), (String)name)).findAny());
    }

    public ProxyRepository.Registry getRegistry() {
        return this.baseRepository.getRegistry();
    }

    public String getName() {
        return this.baseRepository.getName();
    }

    public List<BundleIdentity> getFitableIdentities() {
        HashMap<String, Map<String, BundleIdentity>> identities = new HashMap<String, Map<String, BundleIdentity>>();
        for (int i = this.repositories.size() - 1; i >= 0; --i) {
            ProxyRepositoryComposite.append(identities, this.repositories.get(i).getFitableIdentities());
        }
        ProxyRepositoryComposite.append(identities, this.baseRepository.getFitableIdentities());
        return identities.values().stream().flatMap(map -> map.values().stream()).collect(Collectors.toList());
    }

    private static void append(Map<String, Map<String, BundleIdentity>> cache, List<BundleIdentity> identities) {
        identities.forEach(identity -> cache.computeIfAbsent(identity.getGenericId(), key -> new HashMap()).putIfAbsent(identity.getFitId(), identity));
    }

    public Optional<Proxy> get(String genericableId, String fitableId) {
        for (ProxyRepository repository : this.repositories) {
            Optional proxy = repository.get(genericableId, fitableId);
            if (!proxy.isPresent()) continue;
            return proxy;
        }
        return this.baseRepository.get(genericableId, fitableId);
    }

    public Proxy get(String genericableId, String fitableId, Supplier<Proxy> factory) {
        Optional<Proxy> optionalProxy = this.get(genericableId, fitableId);
        if (optionalProxy.isPresent()) {
            return optionalProxy.get();
        }
        Proxy proxy = factory.get();
        this.baseRepository.getRegistry().store(genericableId, fitableId, proxy);
        return proxy;
    }
}

