/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.fitframework.broker.client.proxy.support.decorator;

import com.huawei.fit.hakuna.system.mesh.runtime.MeshEntrance;
import com.huawei.fit.hakuna.system.mesh.runtime.entity.MeshContext;
import com.huawei.fitframework.broker.client.Invoker;
import com.huawei.fitframework.broker.client.filter.loadbalance.HostFilter;
import com.huawei.fitframework.broker.client.proxy.Proxy;
import com.huawei.fitframework.broker.client.proxy.support.decorator.ProxyDecorator;
import com.huawei.fitframework.core.common.exception.MethodInvocationException;
import com.huawei.fitframework.core.common.util.ExceptionUtils;
import com.huawei.fitframework.exception.FitException;
import com.huawei.fitframework.exception.MeshException;
import com.huawei.fitframework.exception.SystemError;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractMeshDecorator
extends ProxyDecorator {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractMeshDecorator.class);
    private final String workerId;
    private final String workerHost;

    protected AbstractMeshDecorator(Proxy proxy, String workerId, String workerHost) {
        super(proxy);
        this.workerId = workerId;
        this.workerHost = workerHost;
    }

    @Override
    public <T> T execute(Object ... args) {
        this.mesh(MeshPosition.BEFORE);
        Object result = super.execute(args);
        this.mesh(MeshPosition.AFTER);
        return result;
    }

    protected abstract MeshDirection getMeshDirection();

    protected String getSourceWorkerId() {
        return this.workerId;
    }

    private void mesh(MeshPosition position) {
        Context context = Context.builder().direction(this.getMeshDirection()).position(position).sourceWorkerId(this.getSourceWorkerId()).build();
        try {
            this.mesh(context);
        }
        catch (MethodInvocationException e) {
            Throwable cause = ExceptionUtils.getActualCause((MethodInvocationException)e);
            if (cause instanceof FitException) {
                this.handleFitException((FitException)cause);
            } else {
                this.handleNonFitException(cause);
            }
        }
        catch (FitException e) {
            this.handleFitException(e);
        }
        catch (Throwable t) {
            this.handleNonFitException(t);
        }
    }

    private void mesh(Context context) {
        this.getFactory().getBrokerClient().get(MeshEntrance.class).route().filter((Invoker.Filter)new HostFilter(this.workerHost)).unicast().ignoreDegradation().ignoreTrust().ignoreMesh().context(this.getInvokeContext()).invoke(new Object[]{this.getGenericableId(), this.getFitableId(), context.toMeshContext()});
    }

    private void handleNonFitException(Throwable throwable) {
        log.error("Fail to call mesh entrance.", throwable);
    }

    private void handleFitException(FitException exception) {
        if (exception.getCode() == SystemError.MESH_INTERRUPTED_ERROR.getCode()) {
            throw new MeshException(exception.getGenericableId(), exception.getFitableId(), exception.getMessage());
        }
        if (exception.getCode() == SystemError.MESH_IGNORABLE_ERROR.getCode()) {
            log.debug("Ignore error when call mesh entrance. [errorCode={}]", (Object)exception.getCode());
            return;
        }
        log.info("Fail to call mesh entrance. [genericableId={}, fitableId={}, errorCode={}, errorMessage={}]", new Object[]{exception.getGenericableId(), exception.getFitableId(), exception.getCode(), exception.getMessage()});
    }

    private static class Context {
        private final MeshDirection direction;
        private final MeshPosition position;
        private final String sourceWorkerId;

        MeshContext toMeshContext() {
            return MeshContext.builder().direction(Integer.valueOf(this.direction.getCode())).position(Integer.valueOf(this.position.getCode())).sourceWorerId(this.sourceWorkerId).build();
        }

        @Generated
        Context(MeshDirection direction, MeshPosition position, String sourceWorkerId) {
            this.direction = direction;
            this.position = position;
            this.sourceWorkerId = sourceWorkerId;
        }

        @Generated
        public static ContextBuilder builder() {
            return new ContextBuilder();
        }

        @Generated
        public static class ContextBuilder {
            @Generated
            private MeshDirection direction;
            @Generated
            private MeshPosition position;
            @Generated
            private String sourceWorkerId;

            @Generated
            ContextBuilder() {
            }

            @Generated
            public ContextBuilder direction(MeshDirection direction) {
                this.direction = direction;
                return this;
            }

            @Generated
            public ContextBuilder position(MeshPosition position) {
                this.position = position;
                return this;
            }

            @Generated
            public ContextBuilder sourceWorkerId(String sourceWorkerId) {
                this.sourceWorkerId = sourceWorkerId;
                return this;
            }

            @Generated
            public Context build() {
                return new Context(this.direction, this.position, this.sourceWorkerId);
            }

            @Generated
            public String toString() {
                return "AbstractMeshDecorator.Context.ContextBuilder(direction=" + (Object)((Object)this.direction) + ", position=" + (Object)((Object)this.position) + ", sourceWorkerId=" + this.sourceWorkerId + ")";
            }
        }
    }

    protected static enum MeshPosition {
        BEFORE(1),
        AFTER(2);

        private final int code;

        private MeshPosition(int code) {
            this.code = code;
        }

        @Generated
        public int getCode() {
            return this.code;
        }
    }

    protected static enum MeshDirection {
        IN(1),
        OUT(2);

        private final int code;

        private MeshDirection(int code) {
            this.code = code;
        }

        @Generated
        public int getCode() {
            return this.code;
        }
    }
}

