/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.fitframework.broker.client.proxy.support.decorator;

import com.huawei.fitframework.aspect.AspectCallInfo;
import com.huawei.fitframework.aspect.AspectCallResult;
import com.huawei.fitframework.aspect.AspectContext;
import com.huawei.fitframework.aspect.AspectHandler;
import com.huawei.fitframework.aspect.ProxyCallType;
import com.huawei.fitframework.broker.BundleIdentity;
import com.huawei.fitframework.broker.client.filter.Target;
import com.huawei.fitframework.broker.client.proxy.Proxy;
import com.huawei.fitframework.broker.client.proxy.support.ConcreteRemoteProxy;
import com.huawei.fitframework.broker.client.proxy.support.decorator.ProxyDecorator;
import com.huawei.fitframework.core.common.util.Validation;
import com.huawei.fitframework.exception.FitException;
import com.huawei.fitframework.trust.TrustStage;
import com.huawei.fitframework.trust.TrustStageHandler;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AspectDecorator
extends ProxyDecorator {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AspectDecorator.class);
    private final ProxyCallType callType;

    public AspectDecorator(Proxy proxy, ProxyCallType callType) {
        super(proxy);
        this.callType = callType;
    }

    @Override
    public <T> T execute(Object ... args) {
        AspectContext<?> aspectContext = this.getAspectContext();
        TrustStage trustStage = this.getTrustStage();
        aspectContext.setTrustStage(trustStage);
        Map<AspectHandler, Object> beforeValueMap = this.before(aspectContext);
        AspectCallResult result = new AspectCallResult();
        try {
            Object proxyResult = super.execute(args);
            result.setResult(proxyResult);
            Object t = proxyResult;
            return t;
        }
        catch (FitException e) {
            result.setSucceeded(false);
            result.setStatus(String.valueOf(e.getCode()));
            throw e;
        }
        catch (Exception e) {
            result.setSucceeded(false);
            result.setStatus("EXCEPTION");
            throw e;
        }
        finally {
            this.after(aspectContext, result, beforeValueMap);
        }
    }

    private Map<AspectHandler, Object> before(AspectContext<?> aspectContext) {
        try {
            List handlers = this.proxy().getFactory().getCachedBrokerClient().list(AspectHandler.class).values().stream().map(AspectHandler.class::cast).collect(Collectors.toList());
            HashMap<AspectHandler, Object> result = new HashMap<AspectHandler, Object>();
            for (AspectHandler handler : handlers) {
                result.put(handler, handler.before(aspectContext));
            }
            return result;
        }
        catch (Throwable t) {
            log.error("Aop before error: {}", (Object)t.getMessage());
            return new HashMap<AspectHandler, Object>();
        }
    }

    private void after(AspectContext aspectContext, AspectCallResult result, Map<AspectHandler, Object> beforeValueMap) {
        try {
            beforeValueMap.forEach((key, value) -> {
                aspectContext.setResult(result);
                aspectContext.setBeforeValue(value);
                key.after(aspectContext);
            });
        }
        catch (Throwable t) {
            log.error("Aop after error: {}", (Object)t.getMessage());
        }
    }

    private AspectContext<?> getAspectContext() {
        AspectCallInfo callInfo = AspectCallInfo.builder().target(this.getTarget()).handlerType(this.callType).invokerType(ProxyCallType.LOCAL).clazz(this.getGenericableClass()).targetBundle(new BundleIdentity(this.getGenericableId(), this.getFitableId())).build();
        return new AspectContext(callInfo);
    }

    private Target getTarget() {
        if (this.proxy() instanceof ConcreteRemoteProxy) {
            return ((ConcreteRemoteProxy)this.proxy()).getTarget();
        }
        return null;
    }

    private TrustStage getTrustStage() {
        TrustStageHandler trustStageHandler = (TrustStageHandler)this.getFactory().getCachedBrokerClient().getProxy(TrustStageHandler.class);
        if (trustStageHandler != null) {
            return trustStageHandler.get();
        }
        return TrustStage.UNKNOWN;
    }

    public static Proxy decorate(Proxy proxy, ProxyCallType callType) {
        Validation.notNull((Object)proxy, (String)"The proxy to decorate with aop decorator cannot be null.", (Object[])new Object[0]);
        if (proxy.isAopIgnored()) {
            return proxy;
        }
        return new AspectDecorator(proxy, callType);
    }
}

