/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.fitframework.broker.client.proxy.support.decorator;

import com.huawei.fitframework.broker.client.BrokerClient;
import com.huawei.fitframework.broker.client.RouterV2;
import com.huawei.fitframework.broker.client.filter.route.FitableIdFilter;
import com.huawei.fitframework.broker.client.proxy.Proxy;
import com.huawei.fitframework.broker.client.proxy.support.decorator.ProxyDecorator;
import com.huawei.fitframework.broker.conf.FitableConfiguration;
import com.huawei.fitframework.core.common.exception.MethodInvocationException;
import com.huawei.fitframework.core.common.util.ExceptionUtils;
import com.huawei.fitframework.core.common.util.StringUtils;
import com.huawei.fitframework.core.common.util.Validation;
import com.huawei.fitframework.exception.DegradableException;
import com.huawei.fitframework.trust.TrustStage;
import com.huawei.fitframework.trust.TrustStageHandler;
import java.util.HashSet;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DegradationDecorator
extends ProxyDecorator {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DegradationDecorator.class);

    public DegradationDecorator(Proxy proxy) {
        super(proxy);
    }

    @Override
    public <T> T execute(Object ... args) {
        try {
            return super.execute(args);
        }
        catch (MethodInvocationException e) {
            Throwable cause = ExceptionUtils.getActualCause((MethodInvocationException)e);
            if (cause instanceof DegradableException) {
                DegradableException degradableException = (DegradableException)cause;
                return this.performDegradation(degradableException, args);
            }
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            throw e;
        }
        catch (DegradableException e) {
            return this.performDegradation(e, args);
        }
    }

    private <T> T performDegradation(DegradableException exception, Object ... args) {
        Optional<String> degradationId;
        HashSet<String> executedFitableIds = new HashSet<String>();
        String currentId = exception.getFitableId();
        while ((degradationId = this.degrade(currentId)).isPresent()) {
            executedFitableIds.add(currentId);
            String actualDegradationId = degradationId.get();
            if (executedFitableIds.contains(actualDegradationId)) {
                log.error("Cycle degraded occurs. [sourceFitable={}, currentFitable={}, degradedFitable={}]", new Object[]{exception.getFitableId(), currentId, degradationId});
                break;
            }
            try {
                this.setTrustStageDegradation();
                BrokerClient brokerClient = this.getFactory().getBrokerClient();
                RouterV2 router = this.isGenericProxy() ? brokerClient.get4GenericInvoke(this.getGenericableId()) : brokerClient.get(this.getGenericableClass());
                return (T)router.route((RouterV2.Filter)new FitableIdFilter(new String[]{actualDegradationId})).ignoreDegradation().ignoreTrust().invoke(args);
            }
            catch (MethodInvocationException e) {
                Throwable cause = ExceptionUtils.getActualCause((MethodInvocationException)e);
                if (cause instanceof DegradableException) {
                    log.warn("Degraded fitable executed failed. [fitableId={}, degradationId={}]", (Object)currentId, (Object)actualDegradationId);
                    currentId = actualDegradationId;
                    continue;
                }
                if (cause instanceof RuntimeException) {
                    throw (RuntimeException)cause;
                }
                throw e;
            }
            catch (DegradableException ex) {
                log.warn("Degraded fitable executed failed. [fitableId={}, degradationId={}]", (Object)currentId, (Object)actualDegradationId);
                currentId = actualDegradationId;
            }
        }
        throw exception;
    }

    private void setTrustStageDegradation() {
        TrustStageHandler trustStageHandler = (TrustStageHandler)this.getFactory().getCachedBrokerClient().getProxy(TrustStageHandler.class);
        if (trustStageHandler != null) {
            trustStageHandler.set(TrustStage.DEGRADATION);
        }
    }

    private Optional<String> degrade(String fitableId) {
        return this.proxy().getFactory().getConfigurationLoader().load().fitable(this.getGenericableId(), fitableId).map(FitableConfiguration::degradationFitable).filter(StringUtils::isNotBlank);
    }

    public static Proxy decorate(Proxy proxy) {
        Validation.notNull((Object)proxy, (String)"The proxy to decorate with degradation cannot be null.", (Object[])new Object[0]);
        return new DegradationDecorator(proxy);
    }
}

