/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.fitframework.broker.client.proxy.support.decorator;

import com.huawei.fit.sdk.context.PutGlobalContext;
import com.huawei.fit.sdk.context.RemoveGlobalContext;
import com.huawei.fitframework.broker.client.proxy.Proxy;
import com.huawei.fitframework.broker.client.proxy.support.decorator.AbstractMeshDecorator;
import com.huawei.fitframework.core.common.util.Validation;

public class MeshOutDecorator
extends AbstractMeshDecorator {
    private static final String FIT_MESH_SOURCE_WORKER_ID = "fit.mesh.sourceWorkerId";

    public MeshOutDecorator(Proxy proxy, String workerId, String workerHost) {
        super(proxy, workerId, workerHost);
    }

    public static Proxy decorate(Proxy proxy, String workerId, String workerHost) {
        Validation.notNull((Object)proxy, (String)"The proxy to decorate with mesh out decorator cannot be null.", (Object[])new Object[0]);
        if (proxy.isMeshIgnored()) {
            return proxy;
        }
        return new MeshOutDecorator(proxy, workerId, workerHost);
    }

    @Override
    public <T> T execute(Object ... args) {
        try {
            this.setSourceWorkerId();
            Object t = super.execute(args);
            return t;
        }
        finally {
            this.clearSourceWorkerId();
        }
    }

    @Override
    protected AbstractMeshDecorator.MeshDirection getMeshDirection() {
        return AbstractMeshDecorator.MeshDirection.OUT;
    }

    private void setSourceWorkerId() {
        ((PutGlobalContext)this.getFactory().getCachedBrokerClient().getProxy(PutGlobalContext.class)).process(FIT_MESH_SOURCE_WORKER_ID, this.getSourceWorkerId());
    }

    private void clearSourceWorkerId() {
        ((RemoveGlobalContext)this.getFactory().getCachedBrokerClient().getProxy(RemoveGlobalContext.class)).process(FIT_MESH_SOURCE_WORKER_ID);
    }
}

