/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.fitframework.broker.client.proxy.support.decorator;

import com.huawei.fitframework.broker.client.proxy.Proxy;
import com.huawei.fitframework.broker.client.proxy.support.decorator.ProxyDecorator;
import com.huawei.fitframework.core.common.exception.MethodInvocationException;
import com.huawei.fitframework.core.common.util.ExceptionUtils;
import com.huawei.fitframework.core.common.util.Validation;
import com.huawei.fitframework.exception.FitException;
import com.huawei.fitframework.exception.RetryableException;
import com.huawei.fitframework.exception.SystemError;
import com.huawei.fitframework.trust.TrustStage;
import com.huawei.fitframework.trust.TrustStageHandler;

public class RetryDecorator
extends ProxyDecorator {
    public RetryDecorator(Proxy proxy) {
        super(proxy);
    }

    @Override
    public <T> T execute(Object ... args) {
        try {
            return super.execute(args);
        }
        catch (RetryableException e) {
            return this.doRetry(e, args);
        }
        catch (MethodInvocationException e) {
            Throwable cause = ExceptionUtils.getActualCause((MethodInvocationException)e);
            if (cause instanceof RetryableException) {
                return this.doRetry((RetryableException)cause, args);
            }
            throw e;
        }
    }

    private <T> T doRetry(RetryableException retryableException, Object ... args) {
        int retry = this.getInvokeContext().retry();
        Validation.greaterThanOrEquals((int)retry, (int)0, () -> new FitException(SystemError.USER_ERROR.getCode(), "retry must not less than 0"));
        if (retry <= 0) {
            throw retryableException;
        }
        TrustStageHandler trustStageHandler = (TrustStageHandler)this.getFactory().getCachedBrokerClient().getProxy(TrustStageHandler.class);
        if (trustStageHandler != null) {
            trustStageHandler.set(TrustStage.RETRY);
        }
        RetryableException actualException = retryableException;
        while (retry > 0) {
            try {
                return super.execute(args);
            }
            catch (RetryableException e) {
                --retry;
                actualException = e;
            }
            catch (MethodInvocationException e) {
                Throwable cause = ExceptionUtils.getActualCause((MethodInvocationException)e);
                if (cause instanceof RetryableException) {
                    --retry;
                    actualException = (RetryableException)cause;
                    continue;
                }
                throw e;
            }
        }
        throw actualException;
    }

    public static Proxy decorate(Proxy proxy) {
        Validation.notNull((Object)proxy, (String)"No proxy in RetryDecorator.", (Object[])new Object[0]);
        return new RetryDecorator(proxy);
    }
}

