/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.fitframework.broker.client.proxy.support.decorator;

import com.huawei.fitframework.aspect.TraceSpanHandler;
import com.huawei.fitframework.broker.FitableNotFoundException;
import com.huawei.fitframework.broker.client.BrokerClient;
import com.huawei.fitframework.broker.client.RouterV2;
import com.huawei.fitframework.broker.client.filter.route.FitableIdFilter;
import com.huawei.fitframework.broker.client.proxy.Proxy;
import com.huawei.fitframework.broker.client.proxy.support.decorator.ProxyDecorator;
import com.huawei.fitframework.broker.conf.FitableConfiguration;
import com.huawei.fitframework.broker.conf.GenericableConfiguration;
import com.huawei.fitframework.broker.conf.TrustConfiguration;
import com.huawei.fitframework.core.common.exception.MethodInvocationException;
import com.huawei.fitframework.core.common.util.Validation;
import com.huawei.fitframework.exception.FitException;
import com.huawei.fitframework.exception.SystemError;
import com.huawei.fitframework.trust.TrustStage;
import com.huawei.fitframework.trust.TrustStageHandler;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TrustDecorator
extends ProxyDecorator {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TrustDecorator.class);

    public TrustDecorator(Proxy proxy) {
        super(proxy);
    }

    @Override
    public <T> T execute(Object ... args) {
        this.doValidate(args);
        this.doBefore(args);
        T result = this.doProcess(args);
        this.doAfter(args);
        this.traceSpanIndexIncrease();
        return result;
    }

    private <T> T doProcess(Object[] args) {
        try {
            this.setTrustStage(TrustStage.PROCESS);
            return super.execute(args);
        }
        catch (MethodInvocationException ex) {
            Throwable cause = ex.getCause();
            if (cause instanceof FitException) {
                return this.doError(args, (FitException)cause);
            }
            throw ex;
        }
        catch (FitException ex) {
            return this.doError(args, ex);
        }
    }

    private static String trust(TrustConfiguration conf, String position) {
        Position pos = Position.fromCode(position);
        Validation.notNull((Object)((Object)pos), (String)"The position of trust cannot be null.", (Object[])new Object[0]);
        switch (pos) {
            case VALIDATE: {
                return conf.validate();
            }
            case BEFORE: {
                return conf.before();
            }
            case AFTER: {
                return conf.after();
            }
            case ERROR: {
                return conf.error();
            }
        }
        throw new IllegalStateException("Unknown trust position: " + position);
    }

    private Optional<FitableConfiguration> getFitableConfiguration(String position) {
        return this.proxy().getFactory().getConfigurationLoader().load().genericable(this.getGenericableId()).flatMap(configuration -> this.getFitableConfigurationByTrust(position, (GenericableConfiguration)configuration));
    }

    private Optional<FitableConfiguration> getFitableConfigurationByTrust(String position, GenericableConfiguration genericableConfiguration) {
        if (genericableConfiguration.trust() == null) {
            return Optional.empty();
        }
        String trustId = TrustDecorator.trust(genericableConfiguration.trust(), position);
        return genericableConfiguration.fitable(trustId);
    }

    private Object doTrust(String position, Object[] args) {
        Object executeResult = null;
        try {
            executeResult = this.getFitableConfiguration(position).map(config -> {
                this.setTrustStage(TrustStage.get((String)position));
                return this.doExecute(args, config.id());
            }).orElseThrow(() -> new FitableNotFoundException(this.getGenericableId(), "FitableId not configured."));
        }
        catch (FitException e) {
            if (SystemError.fromCode((int)e.getCode()) == SystemError.Category.NETWORK) {
                log.warn("The network connection fails during the trust validation phase. {}", (Object)e.getMessage());
                log.warn(e.getCause().getMessage());
            }
            throw e;
        }
        return executeResult;
    }

    private Object doExecute(Object[] args, String fitableId) {
        BrokerClient brokerClient = this.getFactory().getBrokerClient();
        RouterV2 router = this.isGenericProxy() ? brokerClient.get4GenericInvoke(this.getGenericableId()) : brokerClient.get(this.getGenericableClass());
        return router.route((RouterV2.Filter)new FitableIdFilter(new String[]{fitableId})).ignoreDegradation().ignoreTrust().invoke(args);
    }

    private void doValidate(Object[] args) {
        try {
            this.doTrust("validate", args);
        }
        catch (FitableNotFoundException fitableNotFoundException) {
            // empty catch block
        }
    }

    private void doBefore(Object[] args) {
        try {
            this.doTrust("before", args);
        }
        catch (FitableNotFoundException fitableNotFoundException) {
        }
        catch (Exception ex) {
            log.debug("Fitable error. [genericId={}, type={}]", new Object[]{this.getGenericableId(), "before", ex});
        }
    }

    private void doAfter(Object[] args) {
        try {
            this.doTrust("after", args);
        }
        catch (FitableNotFoundException fitableNotFoundException) {
        }
        catch (Exception ex) {
            log.debug("Fitable error. [genericId={}, type={}]", new Object[]{this.getGenericableId(), "after", ex});
        }
    }

    private <T> T doError(Object[] args, FitException ex) {
        Object[] actualArgs = new Object[args.length + 1];
        System.arraycopy(args, 0, actualArgs, 0, args.length);
        actualArgs[args.length] = ex;
        try {
            return (T)this.doTrust("error", actualArgs);
        }
        catch (FitableNotFoundException ignored) {
            throw ex;
        }
    }

    private void traceSpanIndexIncrease() {
        TraceSpanHandler traceSpanHandler = (TraceSpanHandler)this.getFactory().getCachedBrokerClient().getProxy(TraceSpanHandler.class);
        if (traceSpanHandler != null) {
            traceSpanHandler.nextSpanIndexToContext();
        }
    }

    private void setTrustStage(TrustStage trustStage) {
        TrustStageHandler trustStageHandler = (TrustStageHandler)this.getFactory().getCachedBrokerClient().getProxy(TrustStageHandler.class);
        if (trustStageHandler != null) {
            trustStageHandler.set(trustStage);
        }
    }

    public static Proxy decorate(Proxy proxy) {
        Validation.notNull((Object)proxy, (String)"The proxy to decorate with trust decorator cannot be null.", (Object[])new Object[0]);
        if (proxy.isTrustIgnored()) {
            return proxy;
        }
        return new TrustDecorator(proxy);
    }

    static enum Position {
        VALIDATE("validate"),
        BEFORE("before"),
        AFTER("after"),
        ERROR("error");

        private final String code;

        private Position(String code) {
            this.code = code;
        }

        static Position fromCode(String code) {
            for (Position position : Position.values()) {
                if (!Objects.equals(code, position.code)) continue;
                return position;
            }
            return null;
        }

        @Generated
        public String getCode() {
            return this.code;
        }
    }
}

