/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.fitframework.broker.client.proxy.support.invoker.support;

import com.huawei.fit.hakuna.system.context.worldwide.GetAllRouteContext;
import com.huawei.fit.matata.tagCenter.tagger.Tag;
import com.huawei.fitLab.matata.ruleEngine.rule.json.Execute;
import com.huawei.fitframework.annotation.Fit;
import com.huawei.fitframework.annotation.Fitable;
import com.huawei.fitframework.annotation.Value;
import com.huawei.fitframework.broker.client.exception.RoutingException;
import com.huawei.fitframework.broker.client.proxy.ProxyFactory;
import com.huawei.fitframework.broker.client.proxy.support.invoker.RuleContainer;
import com.huawei.fitframework.broker.conf.GenericableConfiguration;
import com.huawei.fitframework.broker.conf.GenericableParamConfiguration;
import com.huawei.fitframework.broker.conf.RouteConfiguration;
import com.huawei.fitframework.broker.conf.RuleRouteConfiguration;
import com.huawei.fitframework.broker.conf.TaggerConfiguration;
import com.huawei.fitframework.core.common.util.ArrayUtils;
import com.huawei.fitframework.core.common.util.CollectionUtils;
import com.huawei.fitframework.core.common.util.MapUtils;
import com.huawei.fitframework.core.common.util.StringUtils;
import com.huawei.fitframework.core.common.util.Validation;
import com.huawei.fitframework.exception.FitException;
import com.huawei.fitframework.serialization.JsonSerializer;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Fitable
public class DefaultRuleContainer
implements RuleContainer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultRuleContainer.class);
    private final ProxyFactory factory;
    private final RuleContainer.RuleFactory ruleFactory;

    public DefaultRuleContainer(ProxyFactory factory, RuleContainer.RuleFactory ruleFactory) {
        this.factory = factory;
        this.ruleFactory = ruleFactory;
    }

    public Optional<RuleContainer.Rule> getRule(String genericableId, Object[] args) {
        return this.factory.getConfigurationLoader().load().genericable(genericableId).map(GenericableConfiguration::route).map(RouteConfiguration::rule).map(RuleRouteConfiguration::id).filter(StringUtils::isNotBlank).map(ruleId -> this.ruleFactory.create(ruleId, genericableId, args));
    }

    @Fitable
    public static class DefaultRuleFactory
    implements RuleContainer.RuleFactory {
        @Generated
        private static final Logger log = LoggerFactory.getLogger(DefaultRuleFactory.class);
        private static final String ENVIRONMENT_DELIMITER = ",";
        private final Execute ruleExecutor;
        private final Tag tagGetter;
        private final ProxyFactory factory;
        private final JsonSerializer jsonSerializer;
        private final GetAllRouteContext getAllRouteContext;
        private final String environment;

        public DefaultRuleFactory(@Fit Execute ruleExecutor, @Fit Tag tagGetter, ProxyFactory factory, JsonSerializer jsonSerializer, @Fit GetAllRouteContext getAllRouteContext, @Value(value="${worker.environment}") String environment, @Value(value="${worker.built-in-environments}") String builtInEnvironments, @Value(value="${matata.rule-center.default-environment}") String defaultRuleCenterEnvironment) {
            this.ruleExecutor = ruleExecutor;
            this.tagGetter = tagGetter;
            this.factory = factory;
            this.jsonSerializer = jsonSerializer;
            this.getAllRouteContext = getAllRouteContext;
            log.info("Worker environment is {}. [config=worker.environment]", (Object)environment);
            log.info("Worker built-in environments is {}. [config=worker.built-in-environments]", (Object)builtInEnvironments);
            log.info("Rule-center default environment is {}. [config=matata.rule-center.default-environment]", (Object)defaultRuleCenterEnvironment);
            Validation.notBlank((String)environment, (String)"No environment. [config=worker.environment]", (Object[])new Object[0]);
            Validation.notBlank((String)builtInEnvironments, (String)"No built-in environments. [config=worker.built-in-environments]", (Object[])new Object[0]);
            Validation.notBlank((String)defaultRuleCenterEnvironment, (String)"No default Rule-Center environment. [config=matata.rule-center.default-environment]", (Object[])new Object[0]);
            this.environment = this.isContains(builtInEnvironments, environment) ? environment : defaultRuleCenterEnvironment;
            log.info("Worker environment of Rule-Center is {}.", (Object)this.environment);
        }

        private boolean isContains(String builtInEnvironments, String environment) {
            return Arrays.asList(builtInEnvironments.split(ENVIRONMENT_DELIMITER)).contains(environment);
        }

        public RuleContainer.Rule create(String ruleId, String genericableId, Object[] args) {
            return new DefaultRule(this.ruleExecutor, this.tagGetter, this.factory, this.jsonSerializer, this.getAllRouteContext, ruleId, genericableId, args, this.environment);
        }
    }

    public static class DefaultRule
    implements RuleContainer.Rule {
        private static final String ARGUMENT_PREFIX = "arg";
        private final Execute ruleExecutor;
        private final Tag tagGetter;
        private final ProxyFactory factory;
        private final JsonSerializer jsonSerializer;
        private final String ruleId;
        private final String genericableId;
        private final Object[] args;
        private final String environment;
        private final Map<String, String> routeContextMap;

        DefaultRule(Execute ruleExecutor, Tag tagGetter, ProxyFactory factory, JsonSerializer jsonSerializer, GetAllRouteContext getAllRouteContext, String ruleId, String genericableId, Object[] args, String environment) {
            this.ruleExecutor = ruleExecutor;
            this.tagGetter = tagGetter;
            this.factory = factory;
            this.jsonSerializer = jsonSerializer;
            this.ruleId = ruleId;
            this.genericableId = genericableId;
            this.args = args;
            this.environment = environment;
            this.routeContextMap = getAllRouteContext.process();
        }

        public String execute() {
            log.debug("Prepare to execute rule. [ruleId={}]", (Object)this.ruleId);
            return this.executeRule(this.constructRuleParameter()).orElseThrow(() -> new RoutingException(this.genericableId, StringUtils.format((String)"No matched fitable id. [genericableId={0}, ruleId={1}]", (Object[])new Object[]{this.genericableId, this.ruleId})));
        }

        private String constructRuleParameter() {
            RuleParameter ruleParameter = new RuleParameter(new RuleParameter.Params(this.args), this.constructTags().orElse(null), this.constructContexts());
            return this.jsonSerializer.serialize((Object)ruleParameter.toJsonObject());
        }

        private RuleParameter.Contexts constructContexts() {
            return new RuleParameter.Contexts(this.routeContextMap);
        }

        private Optional<RuleParameter.Tags> constructTags() {
            Collection parameterConfigurations = this.factory.getConfigurationLoader().load().genericable(this.genericableId).map(GenericableConfiguration::params).orElse(Collections.emptyList());
            if (CollectionUtils.isEmpty((Collection)parameterConfigurations)) {
                return Optional.empty();
            }
            RuleParameter.Tags tags = new RuleParameter.Tags();
            parameterConfigurations.stream().filter(parameterConfiguration -> CollectionUtils.isNotEmpty((Collection)parameterConfiguration.taggers())).forEach(parameterConfiguration -> tags.addTags(parameterConfiguration.index(), this.getTags((GenericableParamConfiguration)parameterConfiguration)));
            if (tags.isEmpty()) {
                return Optional.empty();
            }
            return Optional.of(tags);
        }

        private List<String> getTags(GenericableParamConfiguration parameterConfiguration) {
            List<String> taggerIds = this.getTaggerIds(parameterConfiguration);
            String parameter = this.constructTagRuleParameter(parameterConfiguration);
            return this.executeTag(taggerIds, parameter);
        }

        private List<String> getTaggerIds(GenericableParamConfiguration parameterConfiguration) {
            return parameterConfiguration.taggers().stream().filter(Objects::nonNull).map(TaggerConfiguration::id).collect(Collectors.toList());
        }

        private String constructTagRuleParameter(GenericableParamConfiguration parameterConfiguration) {
            int index = parameterConfiguration.index();
            RuleParameter tagParam = new RuleParameter(new RuleParameter.Params(index, this.args[index]), null, this.constructContexts());
            return this.jsonSerializer.serialize((Object)tagParam.toJsonObject());
        }

        private Optional<String> executeRule(String ruleJsonParameter) {
            try {
                String fitableId = this.ruleExecutor.process(this.environment, this.ruleId, ruleJsonParameter);
                log.debug("Calculate fitable id by executing rule from rule engine successfully, result is '{}'. [environment={}, ruleId={}, parameter={}]", new Object[]{fitableId, this.environment, this.ruleId, ruleJsonParameter});
                return StringUtils.isBlank((String)fitableId) ? Optional.empty() : Optional.of(fitableId);
            }
            catch (FitException e) {
                log.warn("Fail to calculate fitable id by executing rule from rule engine. [environment={}, ruleId={}, parameter={}]", new Object[]{this.environment, this.ruleId, ruleJsonParameter, e});
                return Optional.empty();
            }
        }

        private List<String> executeTag(List<String> taggerIds, String parameter) {
            try {
                List tags = this.tagGetter.process(this.environment, taggerIds, parameter);
                log.debug("Calculate tags from tag center successfully, result is {}. [environment={}, taggerIds={}, parameter={}]", new Object[]{tags, this.environment, taggerIds, parameter});
                return CollectionUtils.isEmpty((Collection)tags) ? Collections.emptyList() : tags.stream().filter(StringUtils::isNotBlank).collect(Collectors.toList());
            }
            catch (FitException e) {
                log.warn("Fail to calculate tags from tag center. [environment={}, taggerIds={}, parameter={}]", new Object[]{this.environment, taggerIds, parameter, e});
                return Collections.emptyList();
            }
        }

        private static class RuleParameter {
            private static final String PARAM = "P";
            private static final String TAG = "T";
            private static final String CONTEXT = "C";
            private final Params params;
            private final Tags tags;
            private final Contexts contexts;

            RuleParameter(Params params, Tags tags, Contexts contexts) {
                this.params = params;
                this.tags = tags;
                this.contexts = contexts;
            }

            private static String constructArgumentName(Integer idx) {
                return DefaultRule.ARGUMENT_PREFIX + idx;
            }

            private Map<String, Object> toJsonObject() {
                HashMap<String, Object> jsonObject = new HashMap<String, Object>();
                if (this.params != null && !this.params.isEmpty()) {
                    jsonObject.put(PARAM, this.params.toJsonObject());
                }
                if (this.tags != null && !this.tags.isEmpty()) {
                    jsonObject.put(TAG, this.tags.toJsonObject());
                }
                if (this.contexts != null && !this.contexts.isEmpty()) {
                    jsonObject.put(CONTEXT, this.contexts.toJsonObject());
                }
                return jsonObject;
            }

            private static class Contexts {
                private final Map<String, String> contextMap;

                private Contexts(Map<String, String> contextMap) {
                    this.contextMap = contextMap;
                }

                private boolean isEmpty() {
                    return MapUtils.isEmpty(this.contextMap);
                }

                private Map<String, String> toJsonObject() {
                    return this.contextMap;
                }
            }

            private static class Tags {
                private final Map<Integer, List<String>> argIndexTagsMappings = new HashMap<Integer, List<String>>();

                private Tags() {
                }

                private void addTags(int index, List<String> tags) {
                    List actualTags = tags.stream().filter(StringUtils::isNotBlank).collect(Collectors.toList());
                    this.argIndexTagsMappings.put(index, actualTags);
                }

                private boolean isEmpty() {
                    return this.argIndexTagsMappings.isEmpty();
                }

                private Map<String, Object> toJsonObject() {
                    return this.argIndexTagsMappings.entrySet().stream().collect(Collectors.toMap(entry -> RuleParameter.constructArgumentName((Integer)entry.getKey()), Map.Entry::getValue));
                }
            }

            private static class Params {
                private final Map<Integer, Object> argIndexArgMappings = new HashMap<Integer, Object>();

                private Params(Object[] args) {
                    if (ArrayUtils.isEmpty((Object[])args)) {
                        return;
                    }
                    IntStream.range(0, args.length).forEach(index -> this.argIndexArgMappings.put(index, args[index]));
                }

                private Params(int index, Object value) {
                    this.argIndexArgMappings.put(index, value);
                }

                private boolean isEmpty() {
                    return this.argIndexArgMappings.isEmpty();
                }

                private Map<String, Object> toJsonObject() {
                    return this.argIndexArgMappings.entrySet().stream().collect(Collectors.toMap(entry -> RuleParameter.constructArgumentName((Integer)entry.getKey()), Map.Entry::getValue));
                }
            }
        }
    }
}

