/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.fitframework.broker.client.support;

import com.huawei.fitframework.broker.client.BrokerClient;
import com.huawei.fitframework.broker.client.InvokeContext;
import com.huawei.fitframework.broker.client.RouterV2;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;

public class CachedBrokerClient
implements BrokerClient {
    private final BrokerClient brokerClient;
    private final Map<Class<?>, Object> proxyMap = new ConcurrentHashMap();
    private final Map<Type, Object> proxiesMap = new ConcurrentHashMap<Type, Object>();

    public CachedBrokerClient(BrokerClient brokerClient) {
        this.brokerClient = brokerClient;
    }

    public RouterV2 get(Class<?> genericableClass) {
        return this.brokerClient.get(genericableClass);
    }

    public RouterV2 get4GenericInvoke(String genericableId) {
        return this.brokerClient.get4GenericInvoke(genericableId);
    }

    public <T> T getProxy(Class<T> genericableClass) {
        return (T)Optional.ofNullable(this.proxyMap.get(genericableClass)).map(obj -> obj).orElseGet(() -> {
            Object proxy = this.brokerClient.getProxy(genericableClass);
            if (proxy != null) {
                this.proxyMap.put(genericableClass, proxy);
            }
            return proxy;
        });
    }

    public <T> T getProxyByAlias(Class<T> genericableClass, String alias, InvokeContext invokeContext) {
        return (T)this.brokerClient.getProxyByAlias(genericableClass, alias, invokeContext);
    }

    public <T> T getProxyByRule(Class<T> genericableClass, InvokeContext invokeContext) {
        return (T)this.brokerClient.getProxyByRule(genericableClass, invokeContext);
    }

    public <T> T getProxyByDefault(Class<T> genericableClass, InvokeContext invokeContext) {
        return (T)this.brokerClient.getProxyByDefault(genericableClass, invokeContext);
    }

    public <T> T getProxyByFitableId(Class<T> genericableClass, String fitableId, InvokeContext invokeContext) {
        return (T)this.brokerClient.getProxyByFitableId(genericableClass, fitableId, invokeContext);
    }

    public <T> Map<String, T> list(Type genericableType) {
        return Optional.ofNullable(this.proxiesMap.get(genericableType)).map(obj -> (Map)obj).orElseGet(() -> {
            Map proxies = this.brokerClient.list(genericableType);
            if (proxies != null) {
                this.proxiesMap.put(genericableType, proxies);
            }
            return proxies;
        });
    }
}

