/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.fitframework.broker.client.support;

import com.huawei.fitframework.broker.client.BrokerClient;
import com.huawei.fitframework.broker.client.InvokeContext;
import com.huawei.fitframework.broker.client.RouterV2;
import com.huawei.fitframework.broker.client.filter.route.AliasFilter;
import com.huawei.fitframework.broker.client.filter.route.FitableIdFilter;
import com.huawei.fitframework.broker.client.filter.route.PreferRuleFilter;
import com.huawei.fitframework.broker.client.filter.route.RuleFilter;
import com.huawei.fitframework.broker.client.proxy.ProxyFactory;
import com.huawei.fitframework.broker.client.support.PrivateFitableGenericableDecorator;
import com.huawei.fitframework.broker.client.support.ProxyGenericableAdapter;
import com.huawei.fitframework.broker.client.support.RouterFactory;
import com.huawei.fitframework.broker.client.support.factory.DefaultRouterFactory;
import com.huawei.fitframework.broker.client.util.AnnotationUtils;
import com.huawei.fitframework.conf.Config;
import com.huawei.fitframework.core.common.util.StringUtils;
import com.huawei.fitframework.core.common.util.Validation;
import com.huawei.fitframework.ioc.ComponentBrief;
import com.huawei.fitframework.ioc.ComponentContainer;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultBrokerClient
implements BrokerClient {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultBrokerClient.class);
    private final ComponentContainer container;
    private final ProxyFactory factory;
    private final Config config;
    private final RouterFactory routerFactory;

    public DefaultBrokerClient(ComponentContainer container, ProxyFactory factory, Config config) {
        this.container = (ComponentContainer)Validation.notNull((Object)container, (String)"Component container of a broker client cannot be null.", (Object[])new Object[0]);
        this.factory = (ProxyFactory)Validation.notNull((Object)factory, (String)"Proxy factory of a broker client cannot be null.", (Object[])new Object[0]);
        this.config = (Config)Validation.notNull((Object)config, (String)"Configuration for broker client required but not supplied.", (Object[])new Object[0]);
        this.routerFactory = new DefaultRouterFactory(this.factory, this, this.config);
    }

    public RouterV2 get(Class<?> genericableClass) {
        String genericableId = AnnotationUtils.getGenericableId(genericableClass);
        return this.getRouter(genericableId, false);
    }

    public RouterV2 get4GenericInvoke(String genericableId) {
        return this.getRouter(genericableId, true);
    }

    private RouterV2 getRouter(String genericableId, boolean isGenericInvoke) {
        return this.routerFactory.create(genericableId, isGenericInvoke);
    }

    public <T> T getProxyByAlias(Class<T> genericableClass, String alias, InvokeContext invokeContext) {
        return (T)this.getProxy(genericableClass, () -> this.getMicroProxy(genericableClass, alias), () -> this.dynamicProxy(genericableClass, (RouterV2.Filter)new AliasFilter(new String[]{alias}), invokeContext));
    }

    public <T> T getProxyByRule(Class<T> genericableClass, InvokeContext invokeContext) {
        return (T)this.getProxy(genericableClass, () -> null, () -> this.dynamicProxy(genericableClass, (RouterV2.Filter)this.getMicroProxy(RuleFilter.class, EMPTY_FITABLE_ALIAS), invokeContext));
    }

    public <T> T getProxyByDefault(Class<T> genericableClass, InvokeContext invokeContext) {
        return (T)this.getProxy(genericableClass, () -> this.getMicroProxy(genericableClass, EMPTY_FITABLE_ALIAS), () -> this.dynamicProxy(genericableClass, (RouterV2.Filter)this.getMicroProxy(PreferRuleFilter.class, EMPTY_FITABLE_ALIAS), invokeContext));
    }

    public <T> T getProxyByFitableId(Class<T> genericableClass, String fitableId, InvokeContext invokeContext) {
        return (T)this.getProxy(genericableClass, () -> this.getMicroProxy(genericableClass, EMPTY_FITABLE_ALIAS), () -> this.dynamicProxy(genericableClass, (RouterV2.Filter)new FitableIdFilter(new String[]{fitableId}), invokeContext));
    }

    private <T> T dynamicProxy(Class<T> genericableClass, RouterV2.Filter filter, InvokeContext invokeContext) {
        return ProxyGenericableAdapter.create(this, genericableClass, filter, invokeContext);
    }

    private <T> T getProxy(Class<T> genericableClass, Supplier<T> microProxySupplier, Supplier<T> macroProxySupplier) {
        Validation.notNull(genericableClass, (String)"The class of genericable to fetch proxy cannot be null.", (Object[])new Object[0]);
        if (AnnotationUtils.isNotGenericableInterface(genericableClass)) {
            return null;
        }
        T microProxy = microProxySupplier.get();
        if (microProxy == null) {
            return macroProxySupplier.get();
        }
        return microProxy;
    }

    public <T> Map<String, T> list(Type genericableType) {
        return this.container.list(genericableType).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> this.decorateMicroProxy(genericableType, entry.getValue())));
    }

    private <T> T decorateMicroProxy(Type genericableType, Object fitable) {
        Class<?> genericableInterface = DefaultBrokerClient.toInterface(genericableType);
        if (genericableInterface == null) {
            return (T)fitable;
        }
        return (T)PrivateFitableGenericableDecorator.decorate(this.factory, this.config, genericableInterface, fitable);
    }

    private static Class<?> toInterface(Type type) {
        Class clazz = type instanceof Class ? (Class)type : (type instanceof ParameterizedType ? (Class)((ParameterizedType)type).getRawType() : null);
        return clazz == null || !clazz.isInterface() ? null : clazz;
    }

    private <T> T getMicroProxy(Class<T> genericableClass, String fitableAlias) {
        Optional<ComponentBrief> optionalBrief = this.getMicroProxyBrief(genericableClass, fitableAlias);
        if (optionalBrief.isPresent()) {
            ComponentBrief brief = optionalBrief.get();
            Object component = this.container.get(brief.getComponentName(), new Object[0]).orElse(null);
            T microProxy = PrivateFitableGenericableDecorator.decorate(this.factory, this.config, genericableClass, component);
            log.trace("Micro proxy found, use micro proxy. [genericableClass={}]", (Object)genericableClass.getName());
            return microProxy;
        }
        log.trace("Micro proxy not found, use macro proxy. [genericableClass={}, fitableAlias={}]", (Object)genericableClass.getName(), (Object)fitableAlias);
        return null;
    }

    private Optional<ComponentBrief> getMicroProxyBrief(Class<?> genericableClass, String fitableAlias) {
        if (StringUtils.isBlank((String)fitableAlias)) {
            return this.container.getBrief(genericableClass);
        }
        return this.container.getBrief(fitableAlias);
    }
}

