/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.fitframework.broker.client.support;

import com.huawei.fitframework.broker.FitableNotFoundException;
import com.huawei.fitframework.broker.NoSuchFitableTargetException;
import com.huawei.fitframework.broker.client.InvokeContext;
import com.huawei.fitframework.broker.client.Invoker;
import com.huawei.fitframework.broker.client.RouterV2;
import com.huawei.fitframework.broker.client.filter.Fitable;
import com.huawei.fitframework.broker.client.filter.FitableTarget;
import com.huawei.fitframework.broker.client.filter.Target;
import com.huawei.fitframework.broker.client.proxy.ProxyFactory;
import com.huawei.fitframework.broker.client.support.InvocationStrategy;
import com.huawei.fitframework.broker.client.support.InvocationStrategyFactory;
import com.huawei.fitframework.broker.client.util.EndpointUtils;
import com.huawei.fitframework.broker.client.util.RouterUtils;
import com.huawei.fitframework.broker.client.util.Spi;
import com.huawei.fitframework.broker.conf.GenericableConfiguration;
import com.huawei.fitframework.core.common.util.CollectionUtils;
import com.huawei.fitframework.core.common.util.StringUtils;
import com.huawei.fitframework.core.common.util.Validation;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.BinaryOperator;
import java.util.stream.Collectors;

public class DefaultInvoker
implements Invoker {
    private final ProxyFactory proxyFactory;
    private final Spi spi;
    private final InvocationStrategyFactory invocationStrategyFactory;
    private final String genericableId;
    private final String localWorkerId;
    private final String localWorkerHost;
    private final RouterV2.Filter routeFilter;
    private boolean isLocalOnly;
    private boolean isMulticast;
    private final boolean isGenericInvoke;
    private BinaryOperator<Object> accumulator;
    private Invoker.Filter filter;
    private final List<Fitable> filterWith = new ArrayList<Fitable>();
    private InvokeContext context;
    private boolean withTrust = true;
    private boolean withDegradation = true;
    private boolean withMesh = true;
    private InvocationStrategy strategy;

    public DefaultInvoker(ProxyFactory proxyFactory, Spi spi, InvocationStrategyFactory invocationStrategyFactory, String genericableId, String localWorkerId, String localWorkerHost, boolean isGenericInvoke, RouterV2.Filter routeFilter) {
        this.proxyFactory = (ProxyFactory)Validation.notNull((Object)proxyFactory, (String)"No proxy factory. [genericableId={0}]", (Object[])new Object[]{genericableId});
        this.spi = (Spi)Validation.notNull((Object)spi, (String)"No spi. [genericableId={0}]", (Object[])new Object[]{genericableId});
        this.invocationStrategyFactory = (InvocationStrategyFactory)Validation.notNull((Object)invocationStrategyFactory, (String)"No invocation strategy factory. [genericableId={0}]", (Object[])new Object[]{genericableId});
        this.genericableId = Validation.notBlank((String)genericableId, (String)"No genericable id.", (Object[])new Object[0]);
        this.localWorkerId = Validation.notBlank((String)localWorkerId, (String)"No local worker id. [genericableId={0}]", (Object[])new Object[]{genericableId});
        this.localWorkerHost = Validation.notBlank((String)localWorkerHost, (String)"No local worker host. [genericableId={0}]", (Object[])new Object[]{genericableId});
        this.isGenericInvoke = isGenericInvoke;
        this.routeFilter = routeFilter;
        this.isLocalOnly = this.isGenericableLocalOnly(genericableId);
        this.context = InvokeContext.defaultContext();
    }

    public Invoker context(InvokeContext context) {
        if (context != null) {
            this.context = context;
        }
        return this;
    }

    public Invoker filter(Invoker.Filter filter) {
        this.filter = Invoker.Filter.combine((Invoker.Filter)this.filter, (Invoker.Filter)filter);
        return this;
    }

    public Invoker filterWith(List<Fitable> fitables) {
        this.filterWith.addAll(fitables);
        return this;
    }

    public Invoker localOnly() {
        this.isLocalOnly = true;
        return this;
    }

    public Invoker unicast() {
        this.isMulticast = false;
        return this;
    }

    public Invoker multicast(BinaryOperator<Object> accumulator) {
        this.isMulticast = true;
        this.accumulator = accumulator;
        return this;
    }

    public Invoker ignoreTrust() {
        this.withTrust = false;
        return this;
    }

    public Invoker ignoreDegradation() {
        this.withDegradation = false;
        return this;
    }

    public Invoker ignoreMesh() {
        this.withMesh = false;
        return this;
    }

    public <R> R invoke(Object ... args) {
        this.computeInvocationStrategy();
        List<Fitable> filteredFitables = this.route(args);
        List<FitableTarget> fitableTargets = this.filterFitableTargets(filteredFitables);
        return (R)this.invoke(fitableTargets, args);
    }

    public List<FitableTarget> getFitableTargets(Object ... args) {
        List<Fitable> filteredFitables = this.route(args);
        return this.filterFitableTargets(filteredFitables);
    }

    private List<Fitable> route(Object[] args) {
        List<Fitable> filteredFitables = RouterUtils.filterFitables(this.genericableId, this.routeFilter, args, this.proxyFactory.getConfigurationLoader());
        if (CollectionUtils.isEmpty(filteredFitables)) {
            String message = StringUtils.format((String)"No matched fitables left after routing filter. [genericableId={0}]", (Object[])new Object[]{this.genericableId});
            throw new FitableNotFoundException(this.genericableId, "", message);
        }
        return filteredFitables;
    }

    private void computeInvocationStrategy() {
        InvocationStrategy.Context strategyContext = InvocationStrategy.Context.builder().factory(this.proxyFactory).spi(this.spi).genericableId(this.genericableId).localWorkerId(this.localWorkerId).localWorkerHost(this.localWorkerHost).isGenericInvoke(this.isGenericInvoke).invokeContext(this.context).withTrust(this.withTrust).withDegradation(this.withDegradation).withMesh(this.withMesh).build();
        this.strategy = this.isMulticast ? (this.isLocalOnly ? this.invocationStrategyFactory.multicastLocalOnly(strategyContext, this.accumulator) : this.invocationStrategyFactory.multicast(strategyContext, this.accumulator)) : (this.isLocalOnly ? this.invocationStrategyFactory.unicastLocalOnly(strategyContext) : this.invocationStrategyFactory.unicast(strategyContext));
    }

    private List<FitableTarget> filterFitableTargets(List<Fitable> filteredFitables) {
        List<FitableTarget> filteredTargets;
        if (this.isLocalOnly) {
            filteredTargets = this.getLocalFitableTargets(filteredFitables);
        } else {
            ArrayList<FitableTarget> fitableTargets = new ArrayList<FitableTarget>();
            filteredFitables.stream().map(this::getFitableTargets).forEach(fitableTargets::addAll);
            filteredTargets = fitableTargets;
        }
        if (CollectionUtils.isEmpty(filteredTargets)) {
            String message = StringUtils.format((String)"No matched fitable targets left after invoking filter. [genericableId={0}]", (Object[])new Object[]{this.genericableId});
            throw new FitableNotFoundException(this.genericableId, "", message);
        }
        return filteredTargets;
    }

    private List<FitableTarget> getLocalFitableTargets(List<Fitable> filteredFitables) {
        Target localTarget = this.getLocalTarget();
        return filteredFitables.stream().map(filteredFitable -> FitableTarget.builder().target(localTarget).fitable(filteredFitable).build()).collect(Collectors.toList());
    }

    private List<FitableTarget> getFitableTargets(Fitable fitable) {
        List<Target> toFilterTargets = this.getTargets(fitable);
        List<Target> filteredWithOthers = this.filterWithOtherFitables(toFilterTargets);
        List<Target> filteredTargets = this.filter(fitable, filteredWithOthers);
        return filteredTargets.stream().map(target -> FitableTarget.builder().target(target).fitable(fitable).build()).collect(Collectors.toList());
    }

    private List<Target> getTargets(Fitable fitable) {
        return this.spi.lookup(fitable.getGenericableId(), "1.0.0", fitable.getFitableId());
    }

    private List<Target> filter(Fitable fitable, List<Target> targets) {
        if (this.filter == null) {
            return targets;
        }
        return this.filter.filter(fitable, this.localWorkerId, targets);
    }

    private List<Target> filterWithOtherFitables(List<Target> targets) {
        List<Target> intersection = targets;
        for (Fitable fitable : this.filterWith) {
            intersection = this.intersect(intersection, this.getTargets(fitable));
        }
        return intersection;
    }

    private List<Target> intersect(List<Target> targets, List<Target> toFilterTargets) {
        Set workerIds = toFilterTargets.stream().map(Target::getWorkerId).collect(Collectors.toSet());
        return targets.stream().filter((? super T target) -> workerIds.contains(target.getWorkerId())).collect(Collectors.toList());
    }

    private Target getLocalTarget() {
        List<Target> targets = EndpointUtils.toTargets(this.spi.getLocalApplicationInstance());
        if (CollectionUtils.isEmpty(targets)) {
            return Target.builder().workerId(this.localWorkerId).build();
        }
        if (targets.size() == 1) {
            return targets.get(0);
        }
        throw new NoSuchFitableTargetException(this.genericableId, StringUtils.format((String)"More than 1 local target. [genericableId={0}]", (Object[])new Object[]{this.genericableId}));
    }

    private boolean isGenericableLocalOnly(String genericableId) {
        return this.proxyFactory.getConfigurationLoader().load().genericable(genericableId).map(GenericableConfiguration::localOnly).orElse(false);
    }

    private Object invoke(List<FitableTarget> fitableTargets, Object ... args) {
        return this.strategy.invoke(fitableTargets, args);
    }
}

