/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.fitframework.broker.client.support;

import com.huawei.fitframework.broker.client.Invoker;
import com.huawei.fitframework.broker.client.RouterV2;
import com.huawei.fitframework.broker.client.filter.Fitable;
import com.huawei.fitframework.broker.client.filter.route.GenericableIdFilter;
import com.huawei.fitframework.broker.client.proxy.ProxyFactory;
import com.huawei.fitframework.broker.client.support.InvokerFactory;
import com.huawei.fitframework.broker.client.util.RouterUtils;
import com.huawei.fitframework.broker.conf.ConfigurationLoader;
import com.huawei.fitframework.broker.conf.GenericableConfiguration;
import com.huawei.fitframework.configcenter.ConfigCenterClient;
import com.huawei.fitframework.configcenter.ConfigCenterListener;
import com.huawei.fitframework.core.common.util.CollectionUtils;
import com.huawei.fitframework.core.common.util.StringUtils;
import com.huawei.fitframework.core.common.util.Validation;
import java.util.Collection;
import java.util.List;
import java.util.Optional;

public class DefaultRouterV2
implements RouterV2 {
    private static final String GENERICABLE_RESOURCE_PREFIX = "fit.public.genericables.";
    private final ProxyFactory proxyFactory;
    private final InvokerFactory invokerFactory;
    private final String genericableId;
    private final String localWorkerId;
    private final String localWorkerHost;
    private final boolean isGenericInvoke;
    private final String appName;

    public DefaultRouterV2(ProxyFactory proxyFactory, InvokerFactory invokerFactory, String genericableId, String localWorkerId, String localWorkerHost, String appName, boolean isGenericInvoke) {
        this.proxyFactory = (ProxyFactory)Validation.notNull((Object)proxyFactory, (String)"No proxy factory. [genericableId={0}]", (Object[])new Object[]{genericableId});
        this.invokerFactory = (InvokerFactory)Validation.notNull((Object)invokerFactory, (String)"No invoker factory. [genericableId={0}]", (Object[])new Object[]{genericableId});
        this.genericableId = Validation.notBlank((String)genericableId, (String)"No genericableId.", (Object[])new Object[0]);
        this.localWorkerId = Validation.notBlank((String)localWorkerId, (String)"No local workerId. [genericableId={0}]", (Object[])new Object[]{genericableId});
        this.localWorkerHost = Validation.notBlank((String)localWorkerHost, (String)"No local workerHost. [genericableId={0}]", (Object[])new Object[]{genericableId});
        this.isGenericInvoke = isGenericInvoke;
        this.appName = Validation.notBlank((String)appName, (String)"No appName. [genericableId={0}]", (Object[])new Object[]{genericableId});
        this.downloadGenericableConfiguration(this.genericableId);
    }

    public Invoker route(RouterV2.Filter filter) {
        GenericableIdFilter genericableIdFilter = new GenericableIdFilter(this.genericableId);
        return this.invokerFactory.create(this.genericableId, this.localWorkerId, this.localWorkerHost, this.isGenericInvoke, genericableIdFilter.combine(filter));
    }

    public List<Fitable> getFitables(RouterV2.Filter filter, Object[] args) {
        ConfigurationLoader loader = this.proxyFactory.getConfigurationLoader();
        return RouterUtils.filterFitables(this.genericableId, filter, args, loader);
    }

    private void downloadGenericableConfiguration(String genericableId) {
        if (this.containsGenericConf(genericableId)) {
            return;
        }
        String configPath = GENERICABLE_RESOURCE_PREFIX + genericableId;
        ConfigCenterClient configCenterClient = (ConfigCenterClient)this.proxyFactory.getBrokerClient().getProxyByDefault(ConfigCenterClient.class);
        ConfigCenterListener configCenterListener = (ConfigCenterListener)this.proxyFactory.getBrokerClient().getProxyByDefault(ConfigCenterListener.class);
        configCenterClient.subscribe(StringUtils.format((String)"{0}:genericables", (Object[])new Object[]{this.appName}), configPath);
        configCenterClient.download(configPath, (arg_0, arg_1) -> ((ConfigCenterListener)configCenterListener).onPropertiesChanged(arg_0, arg_1));
    }

    private boolean containsGenericConf(String genericableId) {
        Optional genericable = this.proxyFactory.getConfigurationLoader().load().genericable(genericableId);
        return genericable.isPresent() && CollectionUtils.isNotEmpty((Collection)((GenericableConfiguration)genericable.get()).fitables());
    }
}

