/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.fitframework.broker.client.support;

import com.huawei.fitframework.broker.FitableNotFoundException;
import com.huawei.fitframework.broker.client.proxy.ProxyFactory;
import com.huawei.fitframework.broker.client.util.AnnotationUtils;
import com.huawei.fitframework.conf.Config;
import com.huawei.fitframework.core.common.util.ReflectionUtils;
import com.huawei.fitframework.core.common.util.StringUtils;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrivateFitableGenericableDecorator
implements InvocationHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PrivateFitableGenericableDecorator.class);
    private static final List<String> TRUST_CONFIG_PATH_PREFIX = Arrays.asList("genericable", "private");
    private static final List<String> TRUST_CONFIG_RELATIVE_PATH = Collections.singletonList("trust");
    private final ProxyFactory factory;
    private final Config config;
    private final Class<?> genericableClass;
    private final Object component;

    private PrivateFitableGenericableDecorator(ProxyFactory factory, Config config, Class<?> genericableClass, Object component) {
        this.factory = factory;
        this.config = config;
        this.genericableClass = genericableClass;
        this.component = component;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Object result;
        if (method.getDeclaringClass() == Object.class || !AnnotationUtils.isGenericableMethod((Method)method)) {
            try {
                method.setAccessible(true);
                return method.invoke(this.component, args);
            }
            catch (Throwable t) {
                throw PrivateFitableGenericableDecorator.unwrapThrowable(t);
            }
        }
        Method genericableMethod = this.getFitableMethod(method);
        this.doValidate(genericableMethod, args);
        this.doBefore(genericableMethod, args);
        try {
            method.setAccessible(true);
            result = method.invoke(this.component, args);
        }
        catch (Throwable t) {
            result = this.doError(genericableMethod, args, PrivateFitableGenericableDecorator.unwrapThrowable(t));
        }
        this.doAfter(genericableMethod, args);
        return result;
    }

    private static Throwable unwrapThrowable(Throwable throwable) {
        if (throwable instanceof InvocationTargetException) {
            return ((InvocationTargetException)throwable).getTargetException();
        }
        return throwable;
    }

    private void doValidate(Method method, Object[] arguments) {
        try {
            this.doTrust(method, "validate", arguments);
        }
        catch (FitableNotFoundException fitableNotFoundException) {
            // empty catch block
        }
    }

    private void doBefore(Method method, Object[] arguments) {
        try {
            this.doTrust(method, "before", arguments);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private Object doError(Method method, Object[] arguments, Throwable th) throws Throwable {
        Object[] actualArguments;
        if (arguments == null) {
            actualArguments = new Object[]{th};
        } else {
            actualArguments = new Object[arguments.length + 1];
            System.arraycopy(arguments, 0, actualArguments, 0, arguments.length);
            actualArguments[arguments.length] = th;
        }
        try {
            return this.doTrust(method, "error", actualArguments);
        }
        catch (FitableNotFoundException ignored) {
            throw th;
        }
    }

    private void doAfter(Method method, Object[] arguments) {
        try {
            this.doTrust(method, "after", arguments);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private Object doTrust(Method method, String position, Object ... arguments) {
        String configKey = PrivateFitableGenericableDecorator.getConfigKey(this.genericableClass, method, position);
        String fitableId = this.getConfiguredTrustFitableId(configKey);
        if (!StringUtils.isBlank((String)fitableId)) {
            try {
                return this.executeFitable(method, fitableId, arguments);
            }
            catch (FitableNotFoundException fitableNotFoundException) {
                // empty catch block
            }
        }
        String defaultTrustFitableId = PrivateFitableGenericableDecorator.getFitableId(PrivateFitableGenericableDecorator.sign(this.genericableClass, method), position);
        return this.executeFitable(method, defaultTrustFitableId, arguments);
    }

    private Object executeFitable(Method genericableMethod, String fitableId, Object[] arguments) {
        try {
            return this.factory.getLocalProxy(this.genericableClass, fitableId).execute(arguments);
        }
        catch (Throwable t) {
            if (!(t instanceof FitableNotFoundException)) {
                log.error("Fail to execute trust fitable. [genericable={}, fitable={}, method={}]", new Object[]{this.genericableClass.getName(), fitableId, ReflectionUtils.toString((Method)genericableMethod)});
            }
            throw t;
        }
    }

    private String getConfiguredTrustFitableId(String configKey) {
        Object configuredTrustFitableId = this.config.get(this.component, configKey);
        if (configuredTrustFitableId == null) {
            return null;
        }
        return Objects.toString(configuredTrustFitableId);
    }

    private Method getFitableMethod(Method instanceMethod) throws NoSuchMethodException {
        return this.component.getClass().getMethod(instanceMethod.getName(), instanceMethod.getParameterTypes());
    }

    private static String sign(Class<?> genericableClass, Method method) {
        StringBuilder builder = new StringBuilder(genericableClass.getName()).append('.').append(method.getName()).append('(');
        Parameter[] parameters = method.getParameters();
        if (parameters.length > 1) {
            builder.append(parameters[0].getType().getSimpleName());
            for (int i = 1; i < parameters.length; ++i) {
                builder.append(',').append(parameters[i].getType().getSimpleName());
            }
        }
        return builder.append(')').toString();
    }

    private static String getFitableId(String signature, String position) {
        return signature + ':' + position;
    }

    private static String getConfigKey(Class<?> genericableClass, Method method, String position) {
        ArrayList<String> path = new ArrayList<String>(TRUST_CONFIG_PATH_PREFIX);
        path.add(PrivateFitableGenericableDecorator.sign(genericableClass, method));
        path.addAll(TRUST_CONFIG_RELATIVE_PATH);
        path.add(position);
        return StringUtils.join((char)'.', path);
    }

    public static <T> T decorate(ProxyFactory factory, Config config, Class<T> genericableClass, Object component) {
        Class[] interfaces = new Class[]{genericableClass};
        PrivateFitableGenericableDecorator handler = new PrivateFitableGenericableDecorator(factory, config, genericableClass, component);
        return (T)Proxy.newProxyInstance(component.getClass().getClassLoader(), interfaces, (InvocationHandler)handler);
    }
}

