/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.fitframework.broker.client.support;

import com.huawei.fitframework.broker.client.BrokerClient;
import com.huawei.fitframework.broker.client.InvokeContext;
import com.huawei.fitframework.broker.client.RouterV2;
import com.huawei.fitframework.broker.client.util.AnnotationUtils;
import com.huawei.fitframework.core.common.util.ArrayUtils;
import com.huawei.fitframework.core.common.util.ObjectUtils;
import com.huawei.fitframework.core.common.util.ReflectionUtils;
import com.huawei.fitframework.core.common.util.StringUtils;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProxyGenericableAdapter
implements InvocationHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ProxyGenericableAdapter.class);
    private static final String GENERICABLE_METHOD_NAME = "process";
    private final BrokerClient brokerClient;
    private final Class<?> genericableClass;
    private final RouterV2.Filter filter;
    private final InvokeContext invokeContext;

    public ProxyGenericableAdapter(BrokerClient brokerClient, Class<?> genericableClass, RouterV2.Filter filter, InvokeContext invokeContext) {
        this.brokerClient = brokerClient;
        this.genericableClass = genericableClass;
        this.filter = filter;
        this.invokeContext = invokeContext;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) {
        Object[] actualArgs = (Object[])ObjectUtils.nullIf((Object)args, (Object)ArrayUtils.EMPTY_OBJECT_ARRAY);
        if (ProxyGenericableAdapter.isGenericableMethod(method)) {
            log.debug("Invoke proxy. [class={}, genericableClass={}]", (Object)this.genericableClass.getName(), (Object)this.genericableClass.getName());
            return this.brokerClient.get(this.genericableClass).route(this.filter).context(this.invokeContext).invoke(actualArgs);
        }
        return ReflectionUtils.invoke((Object)proxy, (Method)method, (Object[])actualArgs);
    }

    private static boolean isGenericableMethod(Method method) {
        return !Modifier.isStatic(method.getModifiers()) && StringUtils.equals((String)method.getName(), (String)GENERICABLE_METHOD_NAME);
    }

    public static <T> T create(BrokerClient brokerClient, Class<T> genericableClass, RouterV2.Filter filter, InvokeContext invokeContext) {
        if (!AnnotationUtils.isMacroGenericableInterface(genericableClass)) {
            String className = Optional.ofNullable(genericableClass).map(Class::getName).orElse(null);
            log.warn("Expect macro genericable interface but it is not. [class={}]", (Object)className);
            return null;
        }
        ClassLoader loader = genericableClass.getClassLoader();
        Class[] interfaces = new Class[]{genericableClass};
        ProxyGenericableAdapter handler = new ProxyGenericableAdapter(brokerClient, genericableClass, filter, invokeContext);
        return (T)Proxy.newProxyInstance(loader, interfaces, (InvocationHandler)handler);
    }
}

