/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.fitframework.broker.client.support.factory;

import com.huawei.fit.hakuna.kernel.loadbalance.FilterV3;
import com.huawei.fitframework.broker.client.BrokerClient;
import com.huawei.fitframework.broker.client.support.InvocationStrategy;
import com.huawei.fitframework.broker.client.support.InvocationStrategyFactory;
import com.huawei.fitframework.broker.client.support.invoke.LocalOnlyMulticastInvocationStrategy;
import com.huawei.fitframework.broker.client.support.invoke.LocalOnlyUnicastInvocationStrategy;
import com.huawei.fitframework.broker.client.support.invoke.MulticastInvocationStrategy;
import com.huawei.fitframework.broker.client.support.invoke.UnicastInvocationStrategy;
import java.util.function.BinaryOperator;

public class DefaultInvocationStrategyFactory
implements InvocationStrategyFactory {
    private final FilterV3 filter;
    private final BrokerClient brokerClient;

    public DefaultInvocationStrategyFactory(BrokerClient brokerClient) {
        this.filter = (FilterV3)brokerClient.getProxyByDefault(FilterV3.class);
        this.brokerClient = brokerClient;
    }

    @Override
    public UnicastInvocationStrategy unicast(InvocationStrategy.Context context) {
        return new UnicastInvocationStrategy(context, this.filter, this.brokerClient);
    }

    @Override
    public LocalOnlyUnicastInvocationStrategy unicastLocalOnly(InvocationStrategy.Context context) {
        return new LocalOnlyUnicastInvocationStrategy(context);
    }

    @Override
    public MulticastInvocationStrategy multicast(InvocationStrategy.Context context, BinaryOperator<Object> accumulator) {
        return new MulticastInvocationStrategy(context, accumulator);
    }

    @Override
    public LocalOnlyMulticastInvocationStrategy multicastLocalOnly(InvocationStrategy.Context context, BinaryOperator<Object> accumulator) {
        return new LocalOnlyMulticastInvocationStrategy(context, accumulator);
    }
}

