/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.fitframework.broker.client.support.factory;

import com.huawei.fitframework.broker.client.BrokerClient;
import com.huawei.fitframework.broker.client.RouterV2;
import com.huawei.fitframework.broker.client.proxy.ProxyFactory;
import com.huawei.fitframework.broker.client.support.DefaultRouterV2;
import com.huawei.fitframework.broker.client.support.InvokerFactory;
import com.huawei.fitframework.broker.client.support.RouterFactory;
import com.huawei.fitframework.broker.client.support.factory.DefaultInvokerFactory;
import com.huawei.fitframework.broker.client.util.DefaultSpi;
import com.huawei.fitframework.conf.Config;
import com.huawei.fitframework.core.common.util.LazyLoader;
import com.huawei.fitframework.core.common.util.ObjectUtils;
import com.huawei.fitframework.core.common.util.Validation;

public class DefaultRouterFactory
implements RouterFactory {
    private final ProxyFactory factory;
    private final InvokerFactory invokerFactory;
    private final LazyLoader<String> workerIdLoader;
    private final LazyLoader<String> workerHostLoader;
    private final LazyLoader<String> appNameLoader;

    public DefaultRouterFactory(ProxyFactory factory, BrokerClient brokerClient, Config config) {
        this.factory = (ProxyFactory)Validation.notNull((Object)factory, (String)"No factory.", (Object[])new Object[0]);
        Validation.notNull((Object)brokerClient, (String)"No broker client.", (Object[])new Object[0]);
        DefaultSpi spi = new DefaultSpi(this.factory, config);
        this.invokerFactory = new DefaultInvokerFactory(this.factory, brokerClient, spi);
        this.workerIdLoader = new LazyLoader(() -> (String)ObjectUtils.cast((Object)config.get((Object)this, "server.id")));
        this.workerHostLoader = new LazyLoader(() -> (String)ObjectUtils.cast((Object)config.get((Object)this, "server.host")));
        this.appNameLoader = new LazyLoader(() -> (String)ObjectUtils.cast((Object)config.get((Object)this, "app.name")));
    }

    @Override
    public RouterV2 create(String genericableId, boolean isGenericInvoke) {
        return new DefaultRouterV2(this.factory, this.invokerFactory, genericableId, (String)this.workerIdLoader.get(), (String)this.workerHostLoader.get(), (String)this.appNameLoader.get(), isGenericInvoke);
    }
}

