/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.fitframework.broker.client.support.invoke;

import com.huawei.fit.hakuna.kernel.registry.shared.entity.ApplicationInstance;
import com.huawei.fitframework.broker.client.InvokeContext;
import com.huawei.fitframework.broker.client.filter.Target;
import com.huawei.fitframework.broker.client.proxy.Proxy;
import com.huawei.fitframework.broker.client.proxy.ProxyFactory;
import com.huawei.fitframework.broker.client.proxy.support.decorator.DegradationDecorator;
import com.huawei.fitframework.broker.client.proxy.support.decorator.MeshOutDecorator;
import com.huawei.fitframework.broker.client.proxy.support.decorator.RegisterGenericableClassDecorator;
import com.huawei.fitframework.broker.client.proxy.support.decorator.TrustDecorator;
import com.huawei.fitframework.broker.client.support.InvocationStrategy;
import com.huawei.fitframework.broker.client.util.Spi;
import java.util.Objects;
import lombok.Generated;

public abstract class AbstractInvocationStrategy
implements InvocationStrategy {
    private final ProxyFactory factory;
    private final Spi spi;
    private final String genericableId;
    private final String localWorkerId;
    private final String localWorkerHost;
    private final boolean isGenericInvoke;
    private final InvokeContext context;
    private final boolean withTrust;
    private final boolean withDegradation;
    private final boolean withMesh;

    protected AbstractInvocationStrategy(InvocationStrategy.Context context) {
        this.factory = context.getFactory();
        this.spi = context.getSpi();
        this.genericableId = context.getGenericableId();
        this.localWorkerId = context.getLocalWorkerId();
        this.localWorkerHost = context.getLocalWorkerHost();
        this.isGenericInvoke = context.isGenericInvoke();
        this.context = context.getInvokeContext();
        this.withTrust = context.isWithTrust();
        this.withDegradation = context.isWithDegradation();
        this.withMesh = context.isWithMesh();
    }

    protected ApplicationInstance getLocalInstance() {
        return this.spi.getLocalApplicationInstance();
    }

    protected Proxy getProxy(Target target, String fitableId) {
        Proxy proxy = this.isGenericInvoke ? this.factory.getRemoteGenericProxy(this.genericableId, fitableId, target, this.context) : (this.isLocalInvoke(target) ? this.factory.getLocalProxy(this.genericableId, fitableId) : this.factory.getRemoteProxy(this.genericableId, fitableId, target, this.context));
        return this.decorate(proxy);
    }

    private boolean isLocalInvoke(Target target) {
        return Objects.equals(target.getWorkerId(), this.localWorkerId);
    }

    protected Proxy getLocalProxy(String fitableId) {
        return this.decorate(this.factory.getLocalProxy(this.genericableId, fitableId));
    }

    private Proxy decorate(Proxy proxy) {
        Proxy decorated = proxy;
        decorated = decorated.decoratedBy(DegradationDecorator::decorate, this.withDegradation).decoratedBy(TrustDecorator::decorate, this.withTrust);
        if (this.withMesh) {
            decorated = MeshOutDecorator.decorate(decorated, this.localWorkerId, this.localWorkerHost);
        }
        return RegisterGenericableClassDecorator.decorate(decorated);
    }

    @Generated
    public String getGenericableId() {
        return this.genericableId;
    }
}

