/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.fitframework.broker.client.support.invoke;

import com.huawei.fitframework.broker.client.filter.FitableTarget;
import com.huawei.fitframework.broker.client.support.InvocationStrategy;
import com.huawei.fitframework.broker.client.support.invoke.AbstractInvocationStrategy;
import com.huawei.fitframework.core.common.util.StringUtils;
import com.huawei.fitframework.exception.FitException;
import java.util.List;
import java.util.function.BinaryOperator;

public class MulticastInvocationStrategy
extends AbstractInvocationStrategy {
    private final BinaryOperator<Object> accumulator;

    public MulticastInvocationStrategy(InvocationStrategy.Context context, BinaryOperator<Object> accumulator) {
        super(context);
        this.accumulator = accumulator;
    }

    @Override
    public Object invoke(List<FitableTarget> fitableTargets, Object ... args) {
        return fitableTargets.stream().map(fitableTarget -> this.invokeFitableTarget((FitableTarget)fitableTarget, args)).reduce(null, this.accumulator);
    }

    private Object invokeFitableTarget(FitableTarget fitableTarget, Object[] args) {
        try {
            return this.getProxy(fitableTarget.getTarget(), fitableTarget.getFitable().getFitableId()).execute(args);
        }
        catch (Exception e) {
            throw new FitException(StringUtils.format((String)"No endpoint invoked successfully, the reason might be protocol unsupported. [genericableId={0}]", (Object[])new Object[]{this.getGenericableId()}));
        }
    }
}

