/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.fitframework.broker.client.support.invoke;

import com.huawei.fit.hakuna.kernel.loadbalance.FilterV3;
import com.huawei.fit.hakuna.kernel.registry.shared.entity.ApplicationInstance;
import com.huawei.fitframework.broker.FitableNotFoundException;
import com.huawei.fitframework.broker.TooManyFitablesException;
import com.huawei.fitframework.broker.client.BrokerClient;
import com.huawei.fitframework.broker.client.filter.Fitable;
import com.huawei.fitframework.broker.client.filter.FitableTarget;
import com.huawei.fitframework.broker.client.support.InvocationStrategy;
import com.huawei.fitframework.broker.client.support.invoke.AbstractInvocationStrategy;
import com.huawei.fitframework.broker.client.support.reducer.InstanceReducerFactory;
import com.huawei.fitframework.broker.client.util.EndpointUtils;
import com.huawei.fitframework.core.common.util.CollectionUtils;
import com.huawei.fitframework.core.common.util.StringUtils;
import com.huawei.fitframework.core.common.util.Validation;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class UnicastInvocationStrategy
extends AbstractInvocationStrategy {
    private final FilterV3 filterV3;
    private final InstanceReducerFactory instanceReducerFactory;

    public UnicastInvocationStrategy(InvocationStrategy.Context context, FilterV3 filterV3, BrokerClient brokerClient) {
        super(context);
        this.filterV3 = (FilterV3)Validation.notNull((Object)filterV3, (String)"No load balance filter.", (Object[])new Object[0]);
        this.instanceReducerFactory = (InstanceReducerFactory)brokerClient.getProxyByDefault(InstanceReducerFactory.class);
    }

    @Override
    public Object invoke(List<FitableTarget> fitableTargets, Object ... args) {
        List<ApplicationInstance> instances;
        Map<Fitable, List<FitableTarget>> fitableTargetsMappings = fitableTargets.stream().collect(Collectors.groupingBy(FitableTarget::getFitable));
        if (fitableTargetsMappings.size() > 1) {
            String message = StringUtils.format((String)"More than 1 fitables left before unicast invoking. [genericableId={0}]", (Object[])new Object[]{this.getGenericableId()});
            throw new TooManyFitablesException(this.getGenericableId(), message);
        }
        Fitable fitable = fitableTargets.get(0).getFitable();
        com.huawei.fit.hakuna.kernel.shared.entity.Fitable fitableInfo = this.toFitableInfo(fitable);
        List filteredInstances = this.filterV3.process(fitableInfo, instances = EndpointUtils.toApplicationInstances(fitableTargets));
        if (CollectionUtils.isEmpty((Collection)filteredInstances)) {
            String message = StringUtils.format((String)"No fitable target left after environment-sequence filtering. [genericableId={0}]", (Object[])new Object[]{this.getGenericableId()});
            throw new FitableNotFoundException(fitable.getGenericableId(), fitable.getFitableId(), message);
        }
        ApplicationInstance selectedInstance = this.instanceReducerFactory.create(fitableInfo).reduce(fitableInfo, this.getLocalInstance(), filteredInstances);
        if (selectedInstance == null || CollectionUtils.isEmpty((Collection)selectedInstance.getWorkers())) {
            String message = StringUtils.format((String)"No fitable target left after load balance. [genericableId={0}]", (Object[])new Object[]{this.getGenericableId()});
            throw new FitableNotFoundException(fitable.getGenericableId(), fitable.getFitableId(), message);
        }
        return this.getProxy(EndpointUtils.toTarget(selectedInstance), fitable.getFitableId()).execute(args);
    }

    private com.huawei.fit.hakuna.kernel.shared.entity.Fitable toFitableInfo(Fitable fitable) {
        return com.huawei.fit.hakuna.kernel.shared.entity.Fitable.builder().genericableId(fitable.getGenericableId()).fitableId(fitable.getFitableId()).build();
    }
}

