/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.fitframework.broker.client.support.reducer;

import com.huawei.fit.hakuna.kernel.loadbalance.LoadBalanceV2;
import com.huawei.fit.hakuna.kernel.shared.entity.Fitable;
import com.huawei.fit.sdk.context.GetLocalContext;
import com.huawei.fitframework.annotation.Value;
import com.huawei.fitframework.broker.client.BrokerClient;
import com.huawei.fitframework.broker.client.support.reducer.DefaultLoadBalanceReducer;
import com.huawei.fitframework.broker.client.support.reducer.InstanceReducer;
import com.huawei.fitframework.broker.client.support.reducer.InstanceReducerFactory;
import com.huawei.fitframework.broker.client.support.reducer.RandomInstanceReducer;
import com.huawei.fitframework.broker.client.support.reducer.SpecifyLoadBalanceReducer;
import com.huawei.fitframework.broker.client.util.AnnotationUtils;
import com.huawei.fitframework.broker.conf.ConfigurationLoader;
import com.huawei.fitframework.broker.conf.GenericableConfiguration;
import com.huawei.fitframework.broker.conf.RouteConfiguration;
import com.huawei.fitframework.broker.conf.util.ValueUtils;
import com.huawei.fitframework.conf.Config;
import com.huawei.fitframework.conf.data.AvailableService;
import com.huawei.fitframework.core.common.util.StringUtils;
import java.util.List;
import java.util.Objects;

@com.huawei.fitframework.annotation.Fitable
public class DefaultInstanceReducerFactory
implements InstanceReducerFactory {
    private static final String REGISTRY_AVAILABLE_SERVICES = "matata.registry.available-services";
    private final BrokerClient brokerClient;
    private final GetLocalContext getLocalContext;
    private final ConfigurationLoader configurationLoader;
    private final Config config;
    private final String loadBalanceKey;

    public DefaultInstanceReducerFactory(BrokerClient brokerClient, GetLocalContext getLocalContext, ConfigurationLoader configurationLoader, Config config, @Value(value="${load-balance.key}") String loadBalanceKey) {
        this.brokerClient = brokerClient;
        this.getLocalContext = getLocalContext;
        this.configurationLoader = configurationLoader;
        this.config = config;
        this.loadBalanceKey = loadBalanceKey;
    }

    @Override
    public InstanceReducer create(Fitable fitableInfo) {
        if (this.isIgnoreLoadBalance(fitableInfo)) {
            return new RandomInstanceReducer();
        }
        String key = StringUtils.format((String)this.loadBalanceKey, (Object[])new Object[]{fitableInfo.getGenericableId()});
        String specifiedLoadBalanceFitableId = this.getLocalContext.process(key);
        if (StringUtils.isBlank((String)specifiedLoadBalanceFitableId)) {
            return new DefaultLoadBalanceReducer(this.brokerClient);
        }
        return new SpecifyLoadBalanceReducer(this.brokerClient, specifiedLoadBalanceFitableId);
    }

    private boolean isIgnoreLoadBalance(Fitable fitableInfo) {
        return this.isRegistryFitable(fitableInfo) || this.isDefaultLoadBalance(fitableInfo);
    }

    private boolean isRegistryFitable(Fitable fitableInfo) {
        List registryServicesConfig = (List)ValueUtils.cast((Object)this.config.get((Object)this, REGISTRY_AVAILABLE_SERVICES));
        return registryServicesConfig.stream().map(AvailableService::new).anyMatch(service -> service.isEquals(fitableInfo.getGenericableId(), "1.0.0", fitableInfo.getFitableId()));
    }

    private boolean isDefaultLoadBalance(Fitable fitableInfo) {
        String genericableId = fitableInfo.getGenericableId();
        String fitableId = fitableInfo.getFitableId();
        String loadBalanceGenericableId = AnnotationUtils.getGenericableId(LoadBalanceV2.class);
        return Objects.equals(genericableId, loadBalanceGenericableId) && Objects.equals(this.getDefaultFitableId(loadBalanceGenericableId), fitableId);
    }

    private String getDefaultFitableId(String genericableId) {
        return this.configurationLoader.load().genericable(genericableId).map(GenericableConfiguration::route).map(RouteConfiguration::defaultFitable).orElse("");
    }
}

