/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.fitframework.broker.client.support.reducer;

import com.huawei.fit.hakuna.kernel.registry.shared.entity.ApplicationInstance;
import com.huawei.fit.hakuna.kernel.registry.shared.entity.Worker;
import com.huawei.fit.hakuna.kernel.shared.entity.Fitable;
import com.huawei.fitframework.broker.client.support.reducer.InstanceReducer;
import com.huawei.fitframework.core.common.util.CollectionUtils;
import com.huawei.fitframework.core.common.util.Validation;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class RandomInstanceReducer
implements InstanceReducer {
    @Override
    public ApplicationInstance reduce(Fitable fitableInfo, ApplicationInstance sourceInstance, List<ApplicationInstance> targetInstances) {
        if (CollectionUtils.isEmpty(targetInstances)) {
            return null;
        }
        return this.findLocal(sourceInstance, targetInstances).orElseGet(() -> (ApplicationInstance)targetInstances.get(0));
    }

    private Optional<ApplicationInstance> findLocal(ApplicationInstance sourceInstance, List<ApplicationInstance> targetInstances) {
        return targetInstances.stream().filter(Objects::nonNull).filter(targetInstance -> this.contains(sourceInstance, (ApplicationInstance)targetInstance)).findFirst();
    }

    private boolean contains(ApplicationInstance sourceInstance, ApplicationInstance targetInstance) {
        Validation.isTrue((sourceInstance.getWorkers().size() == 1 ? 1 : 0) != 0, (String)"The worker size of source is not 1", (Object[])new Object[0]);
        Worker sourceWorker = (Worker)sourceInstance.getWorkers().iterator().next();
        if (CollectionUtils.isEmpty((Collection)targetInstance.getWorkers())) {
            return false;
        }
        return targetInstance.getWorkers().stream().filter(Objects::nonNull).anyMatch(worker -> Objects.equals(sourceWorker.getId(), worker.getId()));
    }
}

