/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.fitframework.broker.client.util;

import com.huawei.fit.hakuna.kernel.registry.shared.entity.ApplicationInstance;
import com.huawei.fit.hakuna.kernel.registry.shared.entity.FitableInstance;
import com.huawei.fit.hakuna.kernel.shared.entity.Fitable;
import com.huawei.fit.registry.GetRegistryAddresses;
import com.huawei.fit.registry.entity.Address;
import com.huawei.fitframework.broker.NoAvailableFitableException;
import com.huawei.fitframework.broker.client.filter.Target;
import com.huawei.fitframework.broker.client.proxy.Proxy;
import com.huawei.fitframework.broker.client.proxy.ProxyFactory;
import com.huawei.fitframework.broker.client.util.EndpointUtils;
import com.huawei.fitframework.broker.client.util.Spi;
import com.huawei.fitframework.conf.Config;
import com.huawei.fitframework.conf.data.AvailableService;
import com.huawei.fitframework.core.common.util.CollectionUtils;
import com.huawei.fitframework.core.common.util.ExceptionUtils;
import com.huawei.fitframework.core.common.util.StringUtils;
import com.huawei.fitframework.core.common.util.Validation;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultSpi
implements Spi {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultSpi.class);
    private static final String REGISTRY_AVAILABLE_SERVICES = "matata.registry.available-services";
    private final ProxyFactory factory;
    private final Config config;

    public DefaultSpi(ProxyFactory factory, Config config) {
        this.factory = (ProxyFactory)Validation.notNull((Object)factory, (String)"The proxy factory of SPI cannot be null.", (Object[])new Object[0]);
        this.config = (Config)Validation.notNull((Object)config, (String)"The configuration of SPI cannot be null.", (Object[])new Object[0]);
    }

    @Override
    public List<Target> lookup(String genericableId, String genericableVersion, String fitableId) {
        Validation.notBlank((String)fitableId, (String)"fitable id is required when lookup genericable[{0}]", (Object[])new Object[]{genericableId});
        if (this.isRegistryFitable(genericableId, genericableVersion, fitableId)) {
            return this.getRegistryEndpoints();
        }
        Fitable fitable = Fitable.builder().genericableId(genericableId).genericableVersion(genericableVersion).fitableId(fitableId).fitableVersion("1.0.0").build();
        Proxy getFitableAddresses = this.factory.listLocalFitableIds("bcad5d59d90b4ee88f195cd7356389fc").stream().findFirst().map(getFitServiceAddressListFitableId -> this.factory.getLocalProxy("bcad5d59d90b4ee88f195cd7356389fc", getFitServiceAddressListFitableId)).orElseThrow(() -> new NoAvailableFitableException("bcad5d59d90b4ee88f195cd7356389fc", StringUtils.format((String)"No available fitable found. [genericableId={0}]", (Object[])new Object[]{"bcad5d59d90b4ee88f195cd7356389fc"})));
        FitableInstance fitableInstance = (FitableInstance)getFitableAddresses.execute(new Object[]{fitable});
        return Optional.ofNullable(fitableInstance).map(FitableInstance::getApplicationInstances).filter(CollectionUtils::isNotEmpty).map(applicationInstances -> applicationInstances.stream().map(EndpointUtils::toTargets).flatMap(Collection::stream).collect(Collectors.toList())).orElse(Collections.emptyList());
    }

    @Override
    public ApplicationInstance getLocalApplicationInstance() {
        List<Address> addresses = this.factory.listLocalFitableIds("8f69322009a8411ca7df1e3a67a856e5").stream().map(fitableId -> this.factory.getLocalProxy("8f69322009a8411ca7df1e3a67a856e5", fitableId)).map(rec$ -> ((Proxy)rec$).execute(new Object[0])).filter(Address.class::isInstance).map(Address.class::cast).collect(Collectors.toList());
        return EndpointUtils.toApplicationInstance(addresses);
    }

    private boolean isRegistryFitable(String genericableId, String genericableVersion, String fitableId) {
        List registryServicesConfig = (List)this.config.get((Object)this, REGISTRY_AVAILABLE_SERVICES);
        return registryServicesConfig.stream().map(AvailableService::new).anyMatch(service -> service.isEquals(genericableId, genericableVersion, fitableId));
    }

    private List<Target> getRegistryEndpoints() {
        return this.getRegistryAddresses().stream().filter(Objects::nonNull).map(EndpointUtils::toTarget).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
    }

    private List<Address> getRegistryAddresses() {
        GetRegistryAddresses getRegistryAddresses = (GetRegistryAddresses)this.factory.getBrokerClient().getProxyByDefault(GetRegistryAddresses.class);
        try {
            List addresses = getRegistryAddresses.process();
            log.debug("Get registry addresses: {}.", (Object)addresses);
            return addresses;
        }
        catch (Exception e) {
            log.error("Fail to get registry addresses: {}.", (Object)ExceptionUtils.getReason((Throwable)e));
            log.debug("Fail to get registry addresses.", (Throwable)e);
            return Collections.emptyList();
        }
    }
}

