/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.fitframework.broker.client.util;

import com.huawei.fit.hakuna.kernel.registry.shared.entity.Application;
import com.huawei.fit.hakuna.kernel.registry.shared.entity.ApplicationInstance;
import com.huawei.fit.hakuna.kernel.registry.shared.entity.Endpoint;
import com.huawei.fit.hakuna.kernel.registry.shared.entity.Worker;
import com.huawei.fit.registry.entity.Address;
import com.huawei.fitframework.broker.client.filter.FitableTarget;
import com.huawei.fitframework.broker.client.filter.Target;
import com.huawei.fitframework.core.common.util.CollectionUtils;
import com.huawei.fitframework.core.common.util.Validation;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

public class EndpointUtils {
    public static boolean contains(List<com.huawei.fitLab.core.component.entity.Endpoint> endpointList, com.huawei.fitLab.core.component.entity.Endpoint endpoint) {
        return endpointList.stream().anyMatch(element -> EndpointUtils.equals(element, endpoint));
    }

    private static boolean equals(com.huawei.fitLab.core.component.entity.Endpoint endpointA, com.huawei.fitLab.core.component.entity.Endpoint endpointB) {
        com.huawei.fit.hakuna.shared.entity.Address addressA = endpointA.getAddress();
        com.huawei.fit.hakuna.shared.entity.Address addressB = endpointB.getAddress();
        return Objects.equals(addressA.getHost(), addressB.getHost()) && Objects.equals(addressA.getPort(), addressB.getPort());
    }

    public static ApplicationInstance toApplicationInstance(List<Address> addresses) {
        if (CollectionUtils.isEmpty(addresses)) {
            return ApplicationInstance.builder().build();
        }
        Address address = addresses.iterator().next();
        String environment = address.getEnvironment();
        return ApplicationInstance.builder().formats(address.getFormats()).workers(EndpointUtils.toWorkers(addresses, environment)).build();
    }

    private static List<Worker> toWorkers(List<Address> addresses, String environment) {
        Map<String, List<Address>> workerIdAddressesMap = addresses.stream().collect(Collectors.groupingBy(Address::getId));
        return workerIdAddressesMap.keySet().stream().map(id -> EndpointUtils.toWorker(id, (List)workerIdAddressesMap.get(id), environment)).collect(Collectors.toList());
    }

    private static Worker toWorker(String id, List<Address> addresses, String environment) {
        return Worker.builder().id(id).environment(environment).addresses(EndpointUtils.toAddresses(addresses)).build();
    }

    private static List<com.huawei.fit.hakuna.kernel.registry.shared.entity.Address> toAddresses(List<Address> addresses) {
        Map<String, List<Address>> hostAddressesMap = addresses.stream().collect(Collectors.groupingBy(Address::getHost));
        return hostAddressesMap.keySet().stream().map(host -> EndpointUtils.toAddress(host, (List)hostAddressesMap.get(host))).collect(Collectors.toList());
    }

    private static com.huawei.fit.hakuna.kernel.registry.shared.entity.Address toAddress(String host, List<Address> addresses) {
        return com.huawei.fit.hakuna.kernel.registry.shared.entity.Address.builder().host(host).endpoints(EndpointUtils.toEndPoints(addresses)).build();
    }

    private static List<Endpoint> toEndPoints(List<Address> addresses) {
        return addresses.stream().map(address -> Endpoint.builder().protocol(address.getProtocol()).port(address.getPort()).build()).collect(Collectors.toList());
    }

    public static List<ApplicationInstance> toApplicationInstances(List<FitableTarget> fitableTargets) {
        return fitableTargets.stream().filter(Objects::nonNull).map(EndpointUtils::toApplicationInstance).collect(Collectors.toList());
    }

    private static ApplicationInstance toApplicationInstance(FitableTarget fitableTarget) {
        return ApplicationInstance.builder().formats(fitableTarget.getFormats()).workers(Collections.singletonList(EndpointUtils.toWorker(fitableTarget.getTarget()))).build();
    }

    public static Worker toWorker(Target target) {
        if (target == null) {
            return Worker.builder().build();
        }
        return Worker.builder().addresses(Collections.singletonList(EndpointUtils.toAddress(target))).id(target.getWorkerId()).environment(target.getEnvironment()).build();
    }

    private static com.huawei.fit.hakuna.kernel.registry.shared.entity.Address toAddress(Target target) {
        return com.huawei.fit.hakuna.kernel.registry.shared.entity.Address.builder().host(target.getHost()).endpoints(EndpointUtils.toEndPoints(target)).build();
    }

    private static List<Endpoint> toEndPoints(Target target) {
        if (CollectionUtils.isEmpty((Collection)target.getEndpoints())) {
            return Collections.emptyList();
        }
        return target.getEndpoints().stream().map(endpoint -> Endpoint.builder().protocol(Integer.valueOf(endpoint.getProtocol())).port(Integer.valueOf(endpoint.getPort())).build()).collect(Collectors.toList());
    }

    public static Target toTarget(ApplicationInstance selectedInstance) {
        Validation.equals((Object)selectedInstance.getWorkers().size(), (Object)1, (String)"The worker of the selected instance is not 1", (Object[])new Object[0]);
        Worker worker = (Worker)selectedInstance.getWorkers().iterator().next();
        List formats = selectedInstance.getFormats();
        String applicationName = EndpointUtils.getApplicationName(selectedInstance);
        List<Target> targets = EndpointUtils.toTargets(worker, formats, applicationName);
        return CollectionUtils.isEmpty(targets) ? Target.builder().build() : targets.get(0);
    }

    public static List<Target> toTargets(ApplicationInstance applicationInstance) {
        if (applicationInstance == null || CollectionUtils.isEmpty((Collection)applicationInstance.getWorkers())) {
            return Collections.emptyList();
        }
        return applicationInstance.getWorkers().stream().filter(Objects::nonNull).flatMap(worker -> Objects.requireNonNull(EndpointUtils.toTargets(worker, applicationInstance.getFormats(), EndpointUtils.getApplicationName(applicationInstance))).stream()).collect(Collectors.toList());
    }

    private static List<Target> toTargets(Worker worker, List<Integer> formats, String applicationName) {
        if (CollectionUtils.isEmpty((Collection)worker.getAddresses())) {
            return Collections.singletonList(Target.builder().formats(formats).workerId(worker.getId()).environment(worker.getEnvironment()).applicationName(applicationName).build());
        }
        return worker.getAddresses().stream().map(address -> EndpointUtils.toTarget(worker, formats, applicationName, address)).filter(Optional::isPresent).map(Optional::get).distinct().collect(Collectors.toList());
    }

    private static String getApplicationName(ApplicationInstance applicationInstance) {
        return Optional.ofNullable(applicationInstance.getApplication()).map(Application::getName).orElse("");
    }

    private static Optional<Target> toTarget(Worker worker, List<Integer> formats, String applicationName, com.huawei.fit.hakuna.kernel.registry.shared.entity.Address address) {
        return Optional.ofNullable(address).map(addr -> Target.builder().formats(formats).workerId(worker.getId()).host(addr.getHost()).environment(worker.getEnvironment()).endpoints(EndpointUtils.toTargetEndPoints(addr.getEndpoints())).applicationName(applicationName).build());
    }

    private static List<Target.Endpoint> toTargetEndPoints(List<Endpoint> endpoints) {
        if (CollectionUtils.isEmpty(endpoints)) {
            return Collections.emptyList();
        }
        return endpoints.stream().filter(Objects::nonNull).map(endpoint -> new Target.Endpoint(endpoint.getProtocol().intValue(), endpoint.getPort().intValue())).collect(Collectors.toList());
    }

    public static Optional<Target> toTarget(Address address) {
        Target target = Target.builder().workerId(address.getId()).host(address.getHost()).formats(address.getFormats()).endpoints(Collections.singletonList(new Target.Endpoint(address.getProtocol().intValue(), address.getPort().intValue()))).environment(address.getEnvironment()).build();
        return Optional.of(target);
    }
}

