/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.fitframework.broker.client.util;

import com.huawei.fitframework.annotation.Genericable;
import com.huawei.fitframework.core.common.util.ClassScanner;
import com.huawei.fitframework.core.common.util.Validation;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenericableScanner {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GenericableScanner.class);
    private final ClassScanner classScanner;
    private Map<String, Class<?>> genericableClasses;

    public GenericableScanner(ClassScanner classScanner) {
        this.classScanner = (ClassScanner)Validation.notNull((Object)classScanner, (String)"Class scanner to scan genericables cannot be null.", (Object[])new Object[0]);
        this.classScanner.addClassDetectedObserver(this::onClassDetected);
    }

    public void scan() {
        this.genericableClasses = new HashMap();
        this.classScanner.scan();
    }

    protected void onClassDetected(String className) {
        Class<?> objectClass;
        try {
            objectClass = this.classScanner.getClassLoader().loadClass(className);
        }
        catch (Throwable t) {
            log.warn("Fail to load class: [name={}]", (Object)className);
            log.debug(t.getClass().getName(), t);
            return;
        }
        String genericableId = GenericableScanner.identifyGenericable(objectClass);
        if (genericableId != null) {
            this.genericableClasses.put(genericableId, objectClass);
        }
    }

    private static String identifyGenericable(Class<?> genericableClass) {
        Genericable annotation = genericableClass.getDeclaredAnnotation(Genericable.class);
        if (annotation == null) {
            return null;
        }
        return annotation.value();
    }

    public Map<String, Class<?>> getGenericableClasses() {
        if (this.genericableClasses == null) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(this.genericableClasses);
    }
}

