/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.fitframework.broker.client.util;

import com.huawei.fitframework.broker.FitableNotFoundException;
import com.huawei.fitframework.broker.client.RouterV2;
import com.huawei.fitframework.broker.client.filter.Fitable;
import com.huawei.fitframework.broker.conf.ConfigurationLoader;
import com.huawei.fitframework.broker.conf.GenericableConfiguration;
import com.huawei.fitframework.core.common.util.CollectionUtils;
import com.huawei.fitframework.core.common.util.StringUtils;
import com.huawei.fitframework.core.common.util.Validation;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class RouterUtils {
    public static List<Fitable> filterFitables(String genericableId, RouterV2.Filter filter, Object[] args, ConfigurationLoader loader) {
        Validation.notNull((Object)loader, (String)"No loader.", (Object[])new Object[0]);
        List<Fitable> toFilterFitables = RouterUtils.constructFitables(genericableId, loader);
        if (filter == null) {
            return toFilterFitables;
        }
        return filter.filter(toFilterFitables, args);
    }

    private static List<Fitable> constructFitables(String genericableId, ConfigurationLoader loader) {
        GenericableConfiguration genericableConfiguration = RouterUtils.loadGenericableConfiguration(genericableId, loader);
        List<Fitable> fitables = genericableConfiguration.fitables().stream().map(fitableConfiguration -> new Fitable(genericableId, fitableConfiguration.id(), new ArrayList(fitableConfiguration.aliases()), Objects.equals(fitableConfiguration.id(), genericableConfiguration.route().defaultFitable()))).collect(Collectors.toList());
        Validation.isTrue((boolean)CollectionUtils.isNotEmpty(fitables), () -> new FitableNotFoundException(genericableId, "", StringUtils.format((String)"Fitable configurations not found. [genericableId={0}]", (Object[])new Object[]{genericableId})));
        return fitables;
    }

    private static GenericableConfiguration loadGenericableConfiguration(String genericableId, ConfigurationLoader loader) {
        return (GenericableConfiguration)loader.load().genericable(genericableId).orElseThrow(() -> new FitableNotFoundException(genericableId, "", StringUtils.format((String)"Genericable configuration not found. [genericableId={0}]", (Object[])new Object[]{genericableId})));
    }
}

