/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.fitframework.broker.serialization;

import com.huawei.fitframework.broker.serialization.GenericVersion;
import com.huawei.fitframework.broker.serialization.TagLengthValues;
import com.huawei.fitframework.broker.serialization.support.DefaultRequestMetadata;
import com.huawei.fitframework.serialization.ByteSerializer;

public interface RequestMetadata {
    public static final short CURRENT_VERSION = 2;

    public short getVersion();

    public byte getDataFormat();

    public GenericVersion getGenericVersion();

    public String getGenericId();

    public String getFitId();

    public TagLengthValues getTagValues();

    public static Builder builder() {
        return RequestMetadata.builder(null);
    }

    public static Builder builder(RequestMetadata metadata) {
        return new DefaultRequestMetadata.Builder(metadata);
    }

    default public Builder copy() {
        return RequestMetadata.builder(this);
    }

    public static ByteSerializer<RequestMetadata> serializer() {
        return DefaultRequestMetadata.Serializer.INSTANCE;
    }

    default public byte[] serialize() {
        return ByteSerializer.serialize2Bytes(RequestMetadata.serializer(), (Object)this);
    }

    public static RequestMetadata deserialize(byte[] bytes) {
        return (RequestMetadata)ByteSerializer.deserialize(RequestMetadata.serializer(), (byte[])bytes);
    }

    public static interface Builder {
        public Builder setVersion(short var1);

        public Builder setDataFormat(byte var1);

        public Builder setGenericVersion(GenericVersion var1);

        public Builder setGenericId(String var1);

        public Builder setFitId(String var1);

        public Builder setTagLengthValues(TagLengthValues var1);

        public Builder addTag(int var1, byte[] var2);

        public RequestMetadata build();
    }
}

