/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.fitframework.broker.serialization;

import com.huawei.fitframework.broker.serialization.TagLengthValues;
import com.huawei.fitframework.broker.serialization.support.DefaultResponseMetadata;
import com.huawei.fitframework.serialization.ByteSerializer;

public interface ResponseMetadata {
    public static final short CURRENT_VERSION = 2;

    public short getVersion();

    public byte getDataFormat();

    public boolean isDegradationException();

    public int getCode();

    public String getMessage();

    public TagLengthValues getTagValues();

    public static Builder builder() {
        return ResponseMetadata.builder(null);
    }

    public static Builder builder(ResponseMetadata metadata) {
        return new DefaultResponseMetadata.Builder(metadata);
    }

    default public Builder copy() {
        return ResponseMetadata.builder(this);
    }

    public static ByteSerializer<ResponseMetadata> serializer() {
        return DefaultResponseMetadata.Serializer.INSTANCE;
    }

    default public byte[] serialize() {
        return ByteSerializer.serialize2Bytes(ResponseMetadata.serializer(), (Object)this);
    }

    public static ResponseMetadata deserialize(byte[] bytes) {
        return (ResponseMetadata)ByteSerializer.deserialize(ResponseMetadata.serializer(), (byte[])bytes);
    }

    public static interface Builder {
        public Builder setVersion(short var1);

        public Builder setDataFormat(byte var1);

        public Builder setDegradationException(boolean var1);

        public Builder setCode(int var1);

        public Builder setMessage(String var1);

        public Builder setTagValues(TagLengthValues var1);

        public Builder addTag(int var1, byte[] var2);

        public ResponseMetadata build();
    }
}

