/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.fitframework.broker.serialization.support;

import com.huawei.fitframework.broker.serialization.GenericVersion;
import com.huawei.fitframework.core.common.util.Convert;
import com.huawei.fitframework.core.common.util.IoUtils;
import com.huawei.fitframework.core.common.util.StringUtils;
import com.huawei.fitframework.serialization.ByteSerializer;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import lombok.Generated;

public class DefaultGenericVersion
implements GenericVersion {
    private final byte major;
    private final byte minor;
    private final byte revision;

    public String toString() {
        return StringUtils.format((String)"{0}.{1}.{2}", (Object[])new Object[]{Byte.toUnsignedInt(this.getMajor()), Byte.toUnsignedInt(this.getMinor()), Byte.toUnsignedInt(this.getRevision())});
    }

    public int hashCode() {
        return Arrays.hashCode(ByteSerializer.serialize2Bytes(GenericVersion.serializer(), (Object)this));
    }

    public boolean equals(Object another) {
        if (another instanceof GenericVersion) {
            return this.hashCode() == another.hashCode();
        }
        return false;
    }

    @Override
    @Generated
    public byte getMajor() {
        return this.major;
    }

    @Override
    @Generated
    public byte getMinor() {
        return this.minor;
    }

    @Override
    @Generated
    public byte getRevision() {
        return this.revision;
    }

    @Generated
    private DefaultGenericVersion(byte major, byte minor, byte revision) {
        this.major = major;
        this.minor = minor;
        this.revision = revision;
    }

    public static class Serializer
    implements ByteSerializer<GenericVersion> {
        public static final Serializer INSTANCE = new Serializer();

        public void serialize(GenericVersion version, OutputStream out) throws IOException {
            out.write(Convert.toBytes((byte)version.getMajor()));
            out.write(Convert.toBytes((byte)version.getMinor()));
            out.write(Convert.toBytes((byte)version.getRevision()));
        }

        public GenericVersion deserialize(InputStream in) throws IOException {
            return GenericVersion.builder().setMajor(Convert.toByte((byte[])IoUtils.read((InputStream)in, (int)1))).setMinor(Convert.toByte((byte[])IoUtils.read((InputStream)in, (int)1))).setRevision(Convert.toByte((byte[])IoUtils.read((InputStream)in, (int)1))).build();
        }
    }

    public static final class Builder
    implements GenericVersion.Builder {
        private byte major;
        private byte minor;
        private byte revision;

        public Builder(GenericVersion another) {
            if (another != null) {
                this.major = another.getMajor();
                this.minor = another.getMinor();
                this.revision = another.getRevision();
            }
        }

        @Override
        public Builder setMajor(byte major) {
            this.major = major;
            return this;
        }

        @Override
        public Builder setMinor(byte minor) {
            this.minor = minor;
            return this;
        }

        @Override
        public Builder setRevision(byte revision) {
            this.revision = revision;
            return this;
        }

        @Override
        public GenericVersion build() {
            return new DefaultGenericVersion(this.major, this.minor, this.revision);
        }
    }
}

