/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.fitframework.broker.serialization.support;

import com.huawei.fitframework.broker.serialization.GenericVersion;
import com.huawei.fitframework.broker.serialization.RequestMetadata;
import com.huawei.fitframework.broker.serialization.TagLengthValues;
import com.huawei.fitframework.broker.serialization.support.DefaultTagLengthValues;
import com.huawei.fitframework.core.common.util.Convert;
import com.huawei.fitframework.core.common.util.IoUtils;
import com.huawei.fitframework.core.common.util.StringUtils;
import com.huawei.fitframework.serialization.ByteSerializer;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import lombok.Generated;

public class DefaultRequestMetadata
implements RequestMetadata {
    private final short version;
    private final byte dataFormat;
    private final GenericVersion genericVersion;
    private final String genericId;
    private final String fitId;
    private final TagLengthValues tagValues;

    public int hashCode() {
        return Arrays.hashCode(this.serialize());
    }

    public boolean equals(Object another) {
        if (another instanceof RequestMetadata) {
            return this.hashCode() == another.hashCode();
        }
        return false;
    }

    @Generated
    public String toString() {
        return "DefaultRequestMetadata(version=" + this.getVersion() + ", dataFormat=" + this.getDataFormat() + ", genericVersion=" + this.getGenericVersion() + ", genericId=" + this.getGenericId() + ", fitId=" + this.getFitId() + ", tagValues=" + this.getTagValues() + ")";
    }

    @Generated
    private DefaultRequestMetadata(short version, byte dataFormat, GenericVersion genericVersion, String genericId, String fitId, TagLengthValues tagValues) {
        this.version = version;
        this.dataFormat = dataFormat;
        this.genericVersion = genericVersion;
        this.genericId = genericId;
        this.fitId = fitId;
        this.tagValues = tagValues;
    }

    @Override
    @Generated
    public short getVersion() {
        return this.version;
    }

    @Override
    @Generated
    public byte getDataFormat() {
        return this.dataFormat;
    }

    @Override
    @Generated
    public GenericVersion getGenericVersion() {
        return this.genericVersion;
    }

    @Override
    @Generated
    public String getGenericId() {
        return this.genericId;
    }

    @Override
    @Generated
    public String getFitId() {
        return this.fitId;
    }

    @Override
    @Generated
    public TagLengthValues getTagValues() {
        return this.tagValues;
    }

    public static class Serializer
    implements ByteSerializer<RequestMetadata> {
        public static final Serializer INSTANCE = new Serializer();

        public void serialize(RequestMetadata metadata, OutputStream out) throws IOException {
            out.write(Convert.toBytes((short)metadata.getVersion()));
            out.write(Convert.toBytes((byte)metadata.getDataFormat()));
            GenericVersion.serializer().serialize((Object)metadata.getGenericVersion(), out);
            out.write(StringUtils.stringToBytes((String)metadata.getGenericId()));
            byte[] fitIdBytes = metadata.getFitId().getBytes(StandardCharsets.UTF_8);
            out.write(Convert.toBytes((short)((short)fitIdBytes.length)));
            out.write(fitIdBytes);
            TagLengthValues.serializer().serialize((Object)metadata.getTagValues(), out);
        }

        public RequestMetadata deserialize(InputStream in) throws IOException {
            RequestMetadata.Builder builder = RequestMetadata.builder().setVersion(Convert.toShort((byte[])IoUtils.read((InputStream)in, (int)2))).setDataFormat(Convert.toByte((byte[])IoUtils.read((InputStream)in, (int)1))).setGenericVersion((GenericVersion)GenericVersion.serializer().deserialize(in)).setGenericId(StringUtils.bytesToString((byte[])IoUtils.read((InputStream)in, (int)16)));
            int fitIdLength = Short.toUnsignedInt(Convert.toShort((byte[])IoUtils.read((InputStream)in, (int)2)));
            byte[] fitIdBytes = IoUtils.read((InputStream)in, (int)fitIdLength);
            return builder.setFitId(new String(fitIdBytes, StandardCharsets.UTF_8)).setTagLengthValues((TagLengthValues)TagLengthValues.serializer().deserialize(in)).build();
        }
    }

    public static final class Builder
    implements RequestMetadata.Builder {
        private short version;
        private byte dataFormat;
        private GenericVersion genericVersion;
        private String genericId;
        private String fitId;
        private TagLengthValues tagValues;

        public Builder(RequestMetadata metadata) {
            if (metadata != null) {
                this.version = metadata.getVersion();
                this.dataFormat = metadata.getDataFormat();
                this.genericId = metadata.getGenericId();
                this.genericVersion = metadata.getGenericVersion();
                this.fitId = metadata.getFitId();
                this.tagValues = metadata.getTagValues();
            }
            if (this.tagValues == null) {
                this.tagValues = new DefaultTagLengthValues();
            }
        }

        @Override
        public Builder setVersion(short version) {
            this.version = version;
            return this;
        }

        @Override
        public Builder setDataFormat(byte dataFormat) {
            this.dataFormat = dataFormat;
            return this;
        }

        @Override
        public Builder setGenericId(String genericId) {
            this.genericId = genericId;
            return this;
        }

        @Override
        public Builder setGenericVersion(GenericVersion genericVersion) {
            this.genericVersion = genericVersion;
            return this;
        }

        @Override
        public Builder setFitId(String fitId) {
            this.fitId = fitId;
            return this;
        }

        @Override
        public RequestMetadata.Builder setTagLengthValues(TagLengthValues tagLengthValues) {
            this.tagValues = tagLengthValues != null ? tagLengthValues : new DefaultTagLengthValues();
            return this;
        }

        @Override
        public RequestMetadata.Builder addTag(int tag, byte[] value) {
            this.tagValues.putTag(tag, value);
            return this;
        }

        @Override
        public RequestMetadata build() {
            return new DefaultRequestMetadata(this.version, this.dataFormat, this.genericVersion, this.genericId, this.fitId, this.tagValues);
        }
    }
}

