/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.fitframework.broker.serialization.support;

import com.huawei.fitframework.broker.serialization.ResponseMetadata;
import com.huawei.fitframework.broker.serialization.TagLengthValues;
import com.huawei.fitframework.broker.serialization.support.DefaultTagLengthValues;
import com.huawei.fitframework.core.common.util.Convert;
import com.huawei.fitframework.core.common.util.IoUtils;
import com.huawei.fitframework.serialization.ByteSerializer;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Optional;
import lombok.Generated;

public class DefaultResponseMetadata
implements ResponseMetadata {
    private final short version;
    private final byte dataFormat;
    private final boolean isDegradationException;
    private final int code;
    private final String message;
    private final TagLengthValues tagValues;

    public int hashCode() {
        return Arrays.hashCode(this.serialize());
    }

    public boolean equals(Object another) {
        if (another instanceof ResponseMetadata) {
            return this.hashCode() == another.hashCode();
        }
        return false;
    }

    @Generated
    public String toString() {
        return "DefaultResponseMetadata(version=" + this.getVersion() + ", dataFormat=" + this.getDataFormat() + ", isDegradationException=" + this.isDegradationException() + ", code=" + this.getCode() + ", message=" + this.getMessage() + ", tagValues=" + this.getTagValues() + ")";
    }

    @Generated
    private DefaultResponseMetadata(short version, byte dataFormat, boolean isDegradationException, int code, String message, TagLengthValues tagValues) {
        this.version = version;
        this.dataFormat = dataFormat;
        this.isDegradationException = isDegradationException;
        this.code = code;
        this.message = message;
        this.tagValues = tagValues;
    }

    @Override
    @Generated
    public short getVersion() {
        return this.version;
    }

    @Override
    @Generated
    public byte getDataFormat() {
        return this.dataFormat;
    }

    @Override
    @Generated
    public boolean isDegradationException() {
        return this.isDegradationException;
    }

    @Override
    @Generated
    public int getCode() {
        return this.code;
    }

    @Override
    @Generated
    public String getMessage() {
        return this.message;
    }

    @Override
    @Generated
    public TagLengthValues getTagValues() {
        return this.tagValues;
    }

    public static class Serializer
    implements ByteSerializer<ResponseMetadata> {
        public static final Serializer INSTANCE = new Serializer();

        public void serialize(ResponseMetadata metadata, OutputStream out) throws IOException {
            out.write(Convert.toBytes((short)metadata.getVersion()));
            out.write(Convert.toBytes((byte)metadata.getDataFormat()));
            out.write(Convert.toBytes((boolean)metadata.isDegradationException()));
            out.write(Convert.toBytes((int)metadata.getCode()));
            byte[] messageBytes = Optional.ofNullable(metadata.getMessage()).map(message -> message.getBytes(StandardCharsets.UTF_8)).orElse(new byte[0]);
            out.write(Convert.toBytes((int)messageBytes.length));
            out.write(messageBytes);
            TagLengthValues.serializer().serialize((Object)metadata.getTagValues(), out);
        }

        public ResponseMetadata deserialize(InputStream in) throws IOException {
            ResponseMetadata.Builder builder = ResponseMetadata.builder().setVersion(Convert.toShort((byte[])IoUtils.read((InputStream)in, (int)2))).setDataFormat(Convert.toByte((byte[])IoUtils.read((InputStream)in, (int)1))).setDegradationException(Convert.toBoolean((byte[])IoUtils.read((InputStream)in, (int)1))).setCode(Convert.toInteger((byte[])IoUtils.read((InputStream)in, (int)4)));
            int messageLength = Convert.toInteger((byte[])IoUtils.read((InputStream)in, (int)4));
            byte[] messageBytes = IoUtils.read((InputStream)in, (int)messageLength);
            return builder.setMessage(new String(messageBytes, StandardCharsets.UTF_8)).setTagValues((TagLengthValues)TagLengthValues.serializer().deserialize(in)).build();
        }
    }

    public static final class Builder
    implements ResponseMetadata.Builder {
        private short version;
        private byte dataFormat;
        private boolean isDegradationException;
        private int code;
        private String message;
        private TagLengthValues tagValues;

        public Builder(ResponseMetadata metadata) {
            if (metadata != null) {
                this.version = metadata.getVersion();
                this.dataFormat = metadata.getDataFormat();
                this.isDegradationException = metadata.isDegradationException();
                this.code = metadata.getCode();
                this.message = metadata.getMessage();
                this.tagValues = metadata.getTagValues();
            }
            if (this.tagValues == null) {
                this.tagValues = new DefaultTagLengthValues();
            }
        }

        @Override
        public Builder setVersion(short version) {
            this.version = version;
            return this;
        }

        @Override
        public Builder setDataFormat(byte dataFormat) {
            this.dataFormat = dataFormat;
            return this;
        }

        @Override
        public Builder setDegradationException(boolean isDegradationException) {
            this.isDegradationException = isDegradationException;
            return this;
        }

        @Override
        public Builder setCode(int code) {
            this.code = code;
            return this;
        }

        @Override
        public Builder setMessage(String message) {
            this.message = message;
            return this;
        }

        @Override
        public Builder setTagValues(TagLengthValues tagValues) {
            this.tagValues = tagValues != null ? tagValues : new DefaultTagLengthValues();
            return this;
        }

        @Override
        public Builder addTag(int tag, byte[] value) {
            this.tagValues.putTag(tag, value);
            return this;
        }

        @Override
        public ResponseMetadata build() {
            return new DefaultResponseMetadata(this.version, this.dataFormat, this.isDegradationException, this.code, this.message, this.tagValues);
        }
    }
}

