/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.fitframework.broker.serialization.support;

import com.huawei.fitframework.annotation.Fitable;
import com.huawei.fitframework.broker.client.proxy.ProxyFactory;
import com.huawei.fitframework.broker.serialization.MessageSerializer;
import com.huawei.fitframework.broker.serialization.SerializationService;
import com.huawei.fitframework.core.common.util.CollectionUtils;
import com.huawei.fitframework.core.common.util.MapUtils;
import com.huawei.fitframework.core.common.util.StringUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Fitable
public class DefaultSerializationService
implements SerializationService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultSerializationService.class);
    private static final Pattern SERIALIZER_PATTERN = Pattern.compile("serializer:(\\d+)");
    private final Map<Integer, MessageSerializer> formatSerializerMapping;
    private final ProxyFactory proxyFactory;
    private Map<String, Set<Integer>> genericableIdSupportedFormatMapping;

    public DefaultSerializationService(ProxyFactory proxyFactory, Map<String, MessageSerializer> aliasSerializerMapping) {
        this.proxyFactory = proxyFactory;
        this.formatSerializerMapping = DefaultSerializationService.resolveSerializers(aliasSerializerMapping);
    }

    @PostConstruct
    public void init() {
        this.genericableIdSupportedFormatMapping = this.initSupportedFormatMapping();
    }

    private Map<String, Set<Integer>> initSupportedFormatMapping() {
        return this.proxyFactory.listGenericableIds().stream().filter(StringUtils::isNotBlank).distinct().collect(Collectors.toMap(Function.identity(), this::resolveSupportedSerialization));
    }

    private Set<Integer> resolveSupportedSerialization(String genericableId) {
        return this.formatSerializerMapping.entrySet().stream().filter(entry -> ((MessageSerializer)entry.getValue()).isSupportedSerialization(genericableId)).map(Map.Entry::getKey).collect(Collectors.toSet());
    }

    public Set<Integer> getSupportedFormats(String genericableId) {
        Set<Integer> cachedSupportedFormats = this.genericableIdSupportedFormatMapping.get(genericableId);
        if (CollectionUtils.isNotEmpty(cachedSupportedFormats)) {
            return cachedSupportedFormats;
        }
        Set<Integer> supportedFormats = this.resolveSupportedSerialization(genericableId);
        if (CollectionUtils.isNotEmpty(supportedFormats)) {
            this.genericableIdSupportedFormatMapping.put(genericableId, supportedFormats);
        }
        return supportedFormats;
    }

    private static Map<Integer, MessageSerializer> resolveSerializers(Map<String, MessageSerializer> aliasSerializerMapping) {
        if (MapUtils.isEmpty(aliasSerializerMapping)) {
            return new HashMap<Integer, MessageSerializer>();
        }
        HashMap<Integer, MessageSerializer> serializers = new HashMap<Integer, MessageSerializer>(aliasSerializerMapping.size());
        for (Map.Entry<String, MessageSerializer> entry : aliasSerializerMapping.entrySet()) {
            if (entry.getValue() == null) continue;
            OptionalInt opFormat = DefaultSerializationService.nameSerializer(entry.getKey());
            if (opFormat.isPresent()) {
                log.info("Message serializer detected. [format={}, fitableAlias={}, fitableId={}]", new Object[]{opFormat.getAsInt(), entry.getKey(), entry.getValue().getClass().getName()});
                serializers.put(opFormat.getAsInt(), entry.getValue());
                continue;
            }
            log.warn("Message serializer detected but name cannot recognized. [fitableAlias={}, fitableId={}]", (Object)entry.getKey(), (Object)entry.getValue().getClass().getName());
        }
        return serializers;
    }

    private static OptionalInt nameSerializer(String fitableAlias) {
        String lower = StringUtils.toLowerCase((String)fitableAlias);
        Matcher matcher = SERIALIZER_PATTERN.matcher(lower);
        if (matcher.matches()) {
            return OptionalInt.of(Integer.valueOf(matcher.group(1)));
        }
        return OptionalInt.empty();
    }

    public Set<Integer> listSupportedFormats() {
        return Collections.unmodifiableSet(this.formatSerializerMapping.keySet());
    }

    public Optional<MessageSerializer> get(int format) {
        return Optional.ofNullable(this.formatSerializerMapping.get(format));
    }
}

