/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.yinglong.distributed.entity;

import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;

public enum ResultStatus {
    WAITED("waited"),
    RUNNING("running"),
    SUCCESS("success"),
    PART_SUCCESS("part_success"),
    FAILED("failed"),
    CONFIGURED("configured"),
    NOT_CONFIGURED("not_configured"),
    UNKNOWN("unknown"),
    PASS("pass"),
    NOT_PASS("not_pass"),
    NOT_SUPPORT("not_support"),
    NO_CHECK("no_check"),
    WARING("warning"),
    MANUAL_CONFIRM("manual_confirm");

    private static final EnumSet<ResultStatus> FINISHED_STATUS;
    private static final EnumSet<ResultStatus> RUNNING_STATUS;
    private static final EnumSet<ResultStatus> SUCCESS_STATUS;
    private static final EnumSet<ResultStatus> FAILED_STATUS;
    private static final EnumSet<ResultStatus> BMC_IP_FAILED_STATUS;
    private final String key;

    private ResultStatus(String status) {
        this.key = status;
    }

    public static ResultStatus of(String statusKey, ResultStatus defaultStatus) {
        return Arrays.stream(ResultStatus.values()).filter(resultStatus -> resultStatus.getKey().equalsIgnoreCase(statusKey)).findFirst().orElse(defaultStatus);
    }

    public boolean isFinished() {
        return FINISHED_STATUS.contains((Object)this);
    }

    public boolean isFailed() {
        return FAILED_STATUS.contains((Object)this);
    }

    public boolean isBmcIpFailed() {
        return BMC_IP_FAILED_STATUS.contains((Object)this);
    }

    public boolean isSuccess() {
        return SUCCESS_STATUS.contains((Object)this);
    }

    public boolean isRunning() {
        return RUNNING_STATUS.contains((Object)this);
    }

    public boolean isWaiting() {
        return WAITED == this;
    }

    public static ResultStatus merge(List<ResultStatus> results) {
        if (ResultStatus.isWaited(results)) {
            return WAITED;
        }
        if (ResultStatus.isRunning(results)) {
            return RUNNING;
        }
        if (ResultStatus.isSuccess(results)) {
            return SUCCESS;
        }
        if (ResultStatus.isFailed(results)) {
            return FAILED;
        }
        return PART_SUCCESS;
    }

    private static boolean isFailed(List<ResultStatus> results) {
        return results.stream().allMatch(ResultStatus::isFailed);
    }

    private static boolean isSuccess(List<ResultStatus> results) {
        return results.stream().allMatch(ResultStatus::isSuccess);
    }

    private static boolean isWaited(List<ResultStatus> results) {
        return results.stream().allMatch(ResultStatus::isWaiting);
    }

    private static boolean isRunning(List<ResultStatus> results) {
        return results.stream().anyMatch(ResultStatus::isRunning);
    }

    public String toString() {
        return this.key;
    }

    public String getKey() {
        return this.key;
    }

    static {
        FINISHED_STATUS = EnumSet.of(SUCCESS, new ResultStatus[]{FAILED, PART_SUCCESS, PASS, NOT_SUPPORT, NO_CHECK, WARING});
        RUNNING_STATUS = EnumSet.of(RUNNING);
        SUCCESS_STATUS = EnumSet.of(SUCCESS, PASS, NOT_SUPPORT);
        FAILED_STATUS = EnumSet.of(PART_SUCCESS, new ResultStatus[]{FAILED, UNKNOWN, NOT_PASS, NO_CHECK, WARING});
        BMC_IP_FAILED_STATUS = EnumSet.of(FAILED, UNKNOWN, NOT_PASS, NO_CHECK, WARING);
    }
}

