/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.kmc.common;

public enum InnerHashAlgorithm {
    UNKNOWN_ALGORITHM("UNKNOWN_ALGORITHM", 0),
    HASH_SHA256("HASH_SHA256", 1028),
    HASH_SM3("HASH_SM3", 1031);

    private String hashAlg;
    private int value;

    private InnerHashAlgorithm(String hashAlg, int value) {
        this.hashAlg = hashAlg;
        this.value = value;
    }

    public static InnerHashAlgorithm searchByName(String name) {
        if (name.isEmpty()) {
            return UNKNOWN_ALGORITHM;
        }
        InnerHashAlgorithm algTemp = null;
        try {
            algTemp = InnerHashAlgorithm.valueOf(name);
        }
        catch (IllegalArgumentException e) {
            algTemp = UNKNOWN_ALGORITHM;
        }
        return algTemp != null ? algTemp : UNKNOWN_ALGORITHM;
    }

    public String getHashAlg() {
        return this.hashAlg;
    }

    public int getValue() {
        return this.value;
    }

    public String toString() {
        return "**not support toString**";
    }
}

