/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.fitframework.runtime;

import com.huawei.fitframework.log.support.Log4j2Configurator;
import com.huawei.fitframework.runtime.Arguments;
import com.huawei.fitframework.runtime.FitContext;
import com.huawei.fitframework.runtime.FitRuntimeSettings;
import com.huawei.fitframework.runtime.SystemDirectories;
import com.huawei.fitframework.runtime.support.DefaultFitRuntime;
import com.huawei.fitframework.runtime.util.ArgumentUtils;
import com.huawei.fitframework.system.SystemClassLoaderContainer;

public interface FitRuntime {
    public static FitContext start(long startTime, String[] args) {
        Arguments arguments = FitRuntime.initializeRuntime(args);
        new Log4j2Configurator().configure(arguments.getFrameworkLogConfigFile());
        return FitRuntime.create(FitRuntimeSettings.builder().setStartTime(startTime).setCommandLineArguments(arguments).build()).start();
    }

    public static Arguments initializeRuntime(String[] args) {
        SystemClassLoaderContainer.initialize();
        Arguments arguments = ArgumentUtils.resolve(args);
        SystemDirectories.initialize((String)arguments.getFrameworkDirectory(), arguments.getExtensionDirectories(), arguments.getPluginDirectories());
        return arguments;
    }

    public static FitRuntime create(FitRuntimeSettings settings) {
        return new DefaultFitRuntime(settings);
    }

    public FitContext start();
}

