/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.fitframework.runtime.support;

import com.huawei.fitframework.core.common.util.CollectionUtils;
import com.huawei.fitframework.core.common.util.MapUtils;
import com.huawei.fitframework.runtime.Arguments;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class DefaultArguments
implements Arguments {
    private final String frameworkDirectory;
    private final List<String> extensionDirectories;
    private final List<String> pluginDirectories;
    private final String startupConfigPath;
    private final String logConfigFile;
    private final Map<String, String> keyValues;

    private DefaultArguments(String frameworkDirectory, List<String> extensionDirectories, List<String> pluginDirectories, String startupConfigPath, String logConfigFile, Map<String, String> keyValues) {
        this.frameworkDirectory = frameworkDirectory;
        this.extensionDirectories = extensionDirectories;
        this.pluginDirectories = pluginDirectories;
        this.startupConfigPath = startupConfigPath;
        this.logConfigFile = logConfigFile;
        this.keyValues = keyValues;
    }

    @Override
    public String getFrameworkDirectory() {
        return this.frameworkDirectory;
    }

    @Override
    public List<String> getExtensionDirectories() {
        return Collections.unmodifiableList(this.extensionDirectories);
    }

    @Override
    public List<String> getPluginDirectories() {
        return Collections.unmodifiableList(this.pluginDirectories);
    }

    @Override
    public String getStartupConfigPath() {
        return this.startupConfigPath;
    }

    @Override
    public String getFrameworkLogConfigFile() {
        return this.logConfigFile;
    }

    @Override
    public Map<String, String> getKeyValues() {
        return Collections.unmodifiableMap(this.keyValues);
    }

    public static final class Builder
    implements Arguments.Builder {
        private String frameworkDirectory;
        private final List<String> extensionDirectories = new ArrayList<String>();
        private final List<String> pluginDirectories = new ArrayList<String>();
        private String startupConfigPath;
        private String logConfigFile;
        private final Map<String, String> keyValues = new LinkedHashMap<String, String>();

        @Override
        public Arguments.Builder frameworkDirectory(String frameworkDirectory) {
            this.frameworkDirectory = frameworkDirectory;
            return this;
        }

        @Override
        public Arguments.Builder extensionDirectories(Collection<String> extensionDirectories) {
            this.extensionDirectories.clear();
            if (CollectionUtils.isNotEmpty(extensionDirectories)) {
                this.extensionDirectories.addAll(extensionDirectories);
            }
            return this;
        }

        @Override
        public Arguments.Builder pluginDirectories(Collection<String> pluginDirectories) {
            this.pluginDirectories.clear();
            if (CollectionUtils.isNotEmpty(pluginDirectories)) {
                this.pluginDirectories.addAll(pluginDirectories);
            }
            return this;
        }

        @Override
        public Arguments.Builder startupConfigPath(String startupConfigPath) {
            this.startupConfigPath = startupConfigPath;
            return this;
        }

        @Override
        public Arguments.Builder logConfigFile(String logConfigFile) {
            this.logConfigFile = logConfigFile;
            return this;
        }

        @Override
        public Arguments.Builder keyValues(Map<String, String> keyValues) {
            this.keyValues.clear();
            if (MapUtils.isNotEmpty(keyValues)) {
                this.keyValues.putAll(keyValues);
            }
            return this;
        }

        @Override
        public Arguments build() {
            return new DefaultArguments(this.frameworkDirectory, this.extensionDirectories, this.pluginDirectories, this.startupConfigPath, this.logConfigFile, this.keyValues);
        }
    }
}

